#
# (C) Tenable Network Security
#


if (description)
{
  script_id(21629);
  script_version("$Revision: 1.12 $");
  script_cve_id(
    "CVE-2006-1942",
    "CVE-2006-2775",
    "CVE-2006-2776",
    "CVE-2006-2777",
    "CVE-2006-2778",
    "CVE-2006-2779", 
    "CVE-2006-2780", 
    "CVE-2006-2781",
    "CVE-2006-2782", 
    "CVE-2006-2783",
    "CVE-2006-2785",
    "CVE-2006-2786", 
    "CVE-2006-2787"
  );
  script_bugtraq_id(18228);

  script_name(english:"SeaMonkey < 1.0.2");
  script_summary(english:"Checks version of SeaMonkey");

  desc = "
Synopsis :

A web browser on the remote host is prone to multiple flaws. 

Description :

The installed version of SeaMonkey contains various security issues,
some of which may lead to execution of arbitrary code on the affected
host subject to the user's privileges. 

See also :

http://www.mozilla.org/security/announce/2006/mfsa2006-31.html
http://www.mozilla.org/security/announce/2006/mfsa2006-32.html
http://www.mozilla.org/security/announce/2006/mfsa2006-33.html
http://www.mozilla.org/security/announce/2006/mfsa2006-34.html
http://www.mozilla.org/security/announce/2006/mfsa2006-35.html
http://www.mozilla.org/security/announce/2006/mfsa2006-37.html
http://www.mozilla.org/security/announce/2006/mfsa2006-38.html
http://www.mozilla.org/security/announce/2006/mfsa2006-39.html
http://www.mozilla.org/security/announce/2006/mfsa2006-40.html
http://www.mozilla.org/security/announce/2006/mfsa2006-41.html
http://www.mozilla.org/security/announce/2006/mfsa2006-42.html
http://www.mozilla.org/security/announce/2006/mfsa2006-43.html

Solution : 

Upgrade to SeaMonkey 1.0.2 or later. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("SeaMonkey/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("SeaMonkey/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (ver[0] == 1 && ver[1] == 0 && ver[2] < 2)
) security_hole(get_kb_item("SMB/transport"));
