#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(27536);
  script_version("$Revision: 1.1 $");

  script_cve_id(
    "CVE-2007-1095",
    "CVE-2007-2292",
    "CVE-2006-2894",
    "CVE-2007-3511",
    "CVE-2007-4841",
    "CVE-2007-5334",
    "CVE-2007-5337",
    "CVE-2007-5338",
    "CVE-2007-5339",
    "CVE-2007-5340"
  );
  script_bugtraq_id(18308, 22688, 23668, 24725, 25543, 26132);

  script_name(english:"SeaMonkey < 1.1.5");
  script_summary(english:"Checks version of SeaMonkey");

  desc = "
Synopsis :

A web browser on the remote host is prone to multiple flaws. 

Description :

The installed version of SeaMonkey contains various security issues
which may cause the application to crash or lead to execution of
arbitrary code on the affected host subject to the user's privileges.

See also :

http://www.mozilla.org/security/announce/2007/mfsa2007-28.html
http://www.mozilla.org/security/announce/2007/mfsa2007-29.html
http://www.mozilla.org/security/announce/2007/mfsa2007-30.html
http://www.mozilla.org/security/announce/2007/mfsa2007-31.html
http://www.mozilla.org/security/announce/2007/mfsa2007-32.html
http://www.mozilla.org/security/announce/2007/mfsa2007-33.html
http://www.mozilla.org/security/announce/2007/mfsa2007-34.html
http://www.mozilla.org/security/announce/2007/mfsa2007-35.html
http://www.mozilla.org/security/announce/2007/mfsa2007-36.html

Solution : 

Upgrade to SeaMonkey 1.1.5 or later. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 
  script_dependencies("mozilla_org_installed.nasl");
  script_require_keys("SeaMonkey/Version");

  exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("SeaMonkey/Version");
if (isnull(ver)) exit(0);

if (
  ver[0] < 1 ||
  (
    ver[0] == 1 && 
    (
      ver[1] == 0 ||
      (ver[1] == 1 && ver[2] < 5)
    )
  )
) security_hole(get_kb_item("SMB/transport"));
