#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
# Ref:
# To: BUGTRAQ@SECURITYFOCUS.COM
# Subject: sendmail -bt negative index bug...
# From: Michal Zalewski <lcamtuf@DIONE.IDS.PL>
# Date: Sun, 8 Oct 2000 15:12:46 +0200 
#

if(description)
{
 script_id(10809);
 script_version ("$Revision: 1.14 $");
 
 name["english"] = "Sendmail -bt option Local Overflow";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote mail server is reportedly affected by a buffer overflow
vulnerability. 

Description :

The remote sendmail server, according to its version number, may be
vulnerable to a '-bt' overflow attack that allows a local user to
execute arbitrary commands as root. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2000-10/0109.html
http://archives.neohapsis.com/archives/bugtraq/2001-01/0003.html

Solution : 

Upgrade to Sendmail version 8.11.2 or later.

Risk factor : 

High / CVSS Base Score : 7.2
(CVSS2#AV:L/AC:L/Au:N/C:C/I:C/A:C)";
 script_description(english:desc["english"]);
		    
 
 summary["english"] = "Checks the version number"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison");
 
 family["english"] = "SMTP problems";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl","smtpserver_detect.nasl");
 script_require_keys("SMTP/sendmail");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#
# The script code starts here
#

include("smtp_func.inc");
include("global_settings.inc");

if ( report_paranoia > 1 ) exit(0);


port = get_kb_item("Services/smtp");
if(!port) port = 25;

banner = get_smtp_banner(port: port);

if(banner && "Switch-" >!< banner )
{
 if(egrep(pattern:".*Sendmail.*((8\.(([0-9]\..*)|(10\..*)|(11\.[01])))|SMI-8\.).*",
	string:banner))
 	security_hole(port);
}
