#
# (C) Tenable Network Security
#

if ( NASL_LEVEL < 3000 ) exit(0);

if (description)
{
  script_id(29250);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-5989");
  script_bugtraq_id(26748);
  script_xref(name:"OSVDB", value:"39170");

  script_name(english:"Skype Technologies skype4com URI Handler Remote Heap Corruption Vulnerability");
  script_summary(english:"Checks version of Skype");
 
  desc = "
Synopsis :

The remote Skype client is affected by an buffer overflow vulnerability

Description :

The version of Skype installed on the remote host is vulnerable to a heap
overflow vulnerability in the skype4com uri handler.
A remote attacker have to enduce a user to click on a specially-crafted 
Skype URL to exploit this flaw.

See also :

http://www.zerodayinitiative.com/advisories/ZDI-07-070.html

Solution :

Upgrade to Skype release 3.6.0.216

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("skype_version.nbin", "smb_nativelanman.nasl");
  script_require_keys("Services/skype");
  script_require_ports(139, 445);

  exit(0);
}


# The flaw only affects Windows hosts.
os = get_kb_item("Host/OS/smb");
if (!os || "Windows" >!< os) exit(0);


port = get_kb_item("Services/skype");
if (!port) exit(0);
if (!get_port_state(port)) exit(0);


# nb: "ts = 711112234" => "version = 3.6.0.216"
ts = get_kb_item("Skype/" + port + "/stackTimeStamp");
if (ts && ts < 711112234) security_warning(port);
