#
# (C) Tenable Network Security
#

desc["english"] = "
Synopsis :

The remote share contains Office-related files

Description :

This plugin connects to the remotely accessible SMB shares
and attempts to find office related files (such as .doc, .ppt,
.xls, .pdf etc).

Solution :

Make sure that the files containing confidential information have
proper access controls set on them.

Risk factor :

None
";


if(description)
{
 script_id(23974);
 script_version ("$Revision: 1.4 $");
 
 name["english"] = "SMB share hosting office files";
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Lists .doc, .ppt, .xls and other office related files";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Peer-To-Peer File Sharing";
 script_family(english:family["english"]);
 
 script_dependencies("smb_accessible_shares.nasl","smb_enum_files.nasl");
 script_require_keys("SMB/shares");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_func.inc");
include('global_settings.inc');

# Here we go
#		

monitored_file_ext_type = make_list ("txt","doc","pdf","ppt","xls","csv","rtf","mdb","odc","mde","pub","wri","dif","sxw","sxi","sxc","sdw","sdd","sdc");

name = kb_smb_name();
login = kb_smb_login();
pass =  kb_smb_password();
dom = kb_smb_domain();

report = NULL;

shares = get_kb_list("SMB/shares");
if(!isnull(shares))  shares = make_list(shares);

count = 0;

foreach share (shares)
{
  file_list = NULL;
  if ( share != "ADMIN$" )
  {
    foreach ext (monitored_file_ext_type)
    {	
    if (isnull(file_list)) {
		 k  = get_kb_list("SMB/"+share+"/content/extensions/"+ext);
		 if ( ! isnull(k) )
		 	file_list = make_list(k);
		}
    else 	{
		 k  = get_kb_list("SMB/"+share+"/content/extensions/"+ext);
		 if ( ! isnull(k) )
		  	file_list = make_list(file_list, k);
		}
    }
    if (max_index(file_list) > 0)
    {		 
      report += " + " + share + ' :\n\n';
	foreach file (file_list)
	{
  	 report += file + '\n';
	 count ++;
	}
      report += '\n';
      if ( count > 255 ) break;
    } 
  }
  if ( count > 255 ) break;
} 

if(!isnull(report))
 {
    report = "Plugin output :

Here is a list of office files which have been found on the remote SMB shares :

"+ report;

  report = string(desc["english"],report);
  security_note(port:kb_smb_transport(), data:report);
}

