#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25700);
 script_version("$Revision: 1.3 $");
 script_cve_id("CVE-2007-0041", "CVE-2007-0042", "CVE-2007-0043");

 name["english"] = "Vulnerabilities in .NET Framework Could Allow Remote Code Execution (931212) (Network Check)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote .Net Framework is vulnerable to code execution attack.

Description :

The remote web server is running a version of the ASP.NET framework which contains
multiple vulnerabilities :

- PE Loader Vulnerability: could allow an attacker to execute arbitrary code
with the privilege of the logged-on user;

- ASP.NET NULL Byte Termination Vulnerability: could allow an attacker to
retrieve the content of the web server;

- JIT Compiler Vulnerability: could allow an attacker to execute arbitrary code
with the privilege of the logged-on user.

Solution : 

Microsoft has released a set of patches for .NET Framework 1.0, 1.1 and 2.0 :

http://www.microsoft.com/technet/security/bulletin/ms07-040.mspx

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of the .Net framework by looking at the IIS headers";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("dotnet_framework_version.nasl");
 script_require_ports("Services/www/ASP.Net");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if (! port ) exit(0);

kb =  get_kb_item("www/" + port + "/Microsoft_.NET_Framework_Version");
if ( ! kb ) exit(0);

v = split(kb, sep:'.', keep:FALSE);
for ( i = 0 ; i < max_index(v) ; i ++ ) v[i] = int(v[i]);

if ( (v[0] == 1 && v[1] == 0 && v[2] < 3705) ||
     (v[0] == 1 && v[1] == 0 && v[2] == 3705 && v[3] < 6060)  || # 1.0SP3
      
     (v[0] == 1 && v[1] == 1 && v[2] < 4322) ||
     (v[0] == 1 && v[1] == 1 && v[2] == 4322 && v[3] < 2407) ||  # 1.1 SP1

     (v[0] == 2 && v[1] == 0 && v[2] < 50727 ) ||
     (v[0] == 2 && v[1] == 0 && v[2] == 50727 && v[3] < 832 ) ) security_hole(port);
