#
# (C) Tenable Network Security
#

if(description)
{
 script_id(29855);
 script_version("$Revision: 1.2 $");

 script_cve_id("CVE-2007-5351");
 script_bugtraq_id(26777);
 script_xref(name:"OSVDB", value:"39125");

 name["english"] = "Vulnerability in SMBv2 Could Allow Remote Code Execution (942624) - Network check";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

It is possible to execute code on the remote host.

Description :

The remote version of Windows contains a version of SMBv2 (Server
Message Block) protocol which is vulnerable to several vulnerabilities.

An attacker may exploit these flaws to elevate his privileges and gain
control of the remote host.

Solution : 

Microsoft has released a set of patches for Windows Vista :

http://www.microsoft.com/technet/security/bulletin/ms07-063.mspx

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 942624";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_nativelanman.nasl");
 script_require_keys("Host/OS/smb");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_func.inc");

os = get_kb_item ("Host/OS/smb") ;
if ( ! os || "Windows 6.0" >!< os ) exit(0);

port = kb_smb_transport();
name = kb_smb_name();

if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);

session_init (socket:soc,hostname:name);


# We redefine the list of supported protocols to talk smbv2
protocol[supported_protocol] = "SMB 2.001";
supported_protocol++;


ret = smb_negotiate_protocol (extended:FALSE);
if (!ret)
  exit(0);

# Some checks in the header first
header = get_smb_header (smbblob:ret);
if (!header || strlen(header) < 4)
  exit(0);

head = substr(header, 0, 3);

# patched version no longer works with SMB 2.001 (but SMB 2.002)
if (head == '\xfeSMB')
  security_hole(port);
