#
# (C) Tenable Network Security
#
# Ref: http://www.microsoft.com/technet/security/bulletin/ms02-031.mspx

if(description)
{
 script_id(11336);

 script_cve_id("CVE-2002-0616", "CVE-2002-0617", "CVE-2002-0618", "CVE-2002-0619");
 script_bugtraq_id(4821, 5063, 5064, 5066);
 script_xref(name:"OSVDB", value:"5175");
 
 script_version("$Revision: 1.21 $");

 name["english"] = "Cumulative patches for Excel and Word for Windows (Q324458)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through Excel.

Description :

The remote host has old versions of Word and Excel installed.
An attacker may use these to execute arbitrary code on this host.

To succeed, the attacker would have to send a rogue excel or word
file to the owner of this computer and have it open it.

Solution :

Microsoft has released a set of patches for Office 2000 and XP :

http://www.microsoft.com/technet/security/bulletin/ms02-031.mspx

Risk factor : 

High / CVSS Base Score : 8 
(AV:R/AC:H/Au:NR/C:C/A:C/I:C/B:N)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of WinWord.exe and Excel.exe";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003-2007 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys( "SMB/WindowsVersion", "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");


rootfile = hotfix_get_programfilesdir();
if ( ! rootfile ) exit(1);

share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:rootfile);

product_file["Word"] = "WinWord.exe";
product_file["Excel"] = "Excel.exe";
product_file["PowerPoint"] = "PowerPnt.exe";
product_file["Publisher"] = "Mspub.exe";

products = make_list("Word", "Excel", "PowerPoint", "Publisher");
paths = make_list("Office12", "Office11", "Office10", "Office");


name 	=  kb_smb_name();
login	=  kb_smb_login();
pass  	=  kb_smb_password();
domain 	=  kb_smb_domain();
port    =  kb_smb_transport();


if(!get_port_state(port))exit(1);

soc = open_sock_tcp(port);
if(!soc)exit(1);


session_init(socket:soc, hostname:name);
r = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if ( r != 1 ) exit(1);

foreach product (products)
{
 foreach path (paths)
 {
  file =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\Microsoft Office\" + path + "\" + product_file[product], string:rootfile);

  handle =  CreateFile (file:file, desired_access:GENERIC_READ, file_attributes:FILE_ATTRIBUTE_NORMAL, share_mode:FILE_SHARE_READ, create_disposition:OPEN_EXISTING);
  if ( ! isnull(handle) )
  {
   v =  GetFileVersion(handle:handle);
   CloseFile(handle:handle);
   if ( ! isnull(v) ) 
   {
    set_kb_item(name:"SMB/Office/" + product + "/Version", value:string(v[0], ".", v[1], ".", v[2], ".", v[3]));
    break;
   }
  }
 }
}


NetUseDel();

excel_version = get_kb_item("SMB/Office/Excel/Version");
word_version = get_kb_item("SMB/Office/Excel/Version");

if ( ! isnull(excel_version) ) 
{
 if ( excel_version[0] == 9 && excel_version[1] == 0 && excel_version[2] == 0 && excel_version[3] < 6508 ) 
 {
	hotfix_security_hole();
	exit(0);
 }
 else if ( excel_version[0] == 10 && excel_version[1] == 0 && excel_version[2] < 4109 ) 
 {
	hotfix_security_hole();
	exit(0);
 }
}

if ( ! isnull(word_version) ) 
{
 if ( word_version[0] == 10 && word_version[1] == 0 && ( word_version[2] < 4009 || (word_version[2] == 4009 && word_version[3] < 3501)) ) 
 {
	hotfix_security_hole();
	exit(0);
 }
}
