#
#
# (C) Tenable Network Security
#
#
# Fixed in Windows XP SP1
#
# Vulnerable versions :
# 	Media Player in Windows XP preSP1 
# 	Media Player 6.4
#	Media Player 7.1
#
#
# Supercedes MS01-056
#

if(description)
{
 script_id(11302);
 script_bugtraq_id(5107, 5109, 5110);
 script_version("$Revision: 1.18 $");
 script_cve_id("CVE-2002-0372", "CVE-2002-0373", "CVE-2002-0615");
 
 
 name["english"] = "Cumulative patch for Windows Media Player (Q320920)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the media player.

Description :

The remote version of Windows Media Player is vulnerable to various flaws :
- A remote attacker may be able to execute arbitrary code  when sending a 
  badly formed file
	  
- A local attacker may gain SYSTEM privileges

Solution :

Microsoft has released a set of patches for Windows XP :

http://www.microsoft.com/technet/security/bulletin/ms02-032.mspx

Risk factor : 

High / CVSS Base Score : 8 
(AV:R/AC:H/Au:NR/C:C/A:C/I:C/B:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the version of Media Player";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 - 2005 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

# FP -> superseded by many other patches.
exit(0);
