#
# (C) Tenable Network Security
#

if(description)
{
 script_id(18025);
 script_cve_id("CVE-2005-0562");
 script_bugtraq_id(13114);
 script_xref(name:"OSVDB", value:"15468");

 script_version("$Revision: 1.11 $");

 name["english"] = "Vulnerability in MSN Messenger Could Lead to Remote Code Execution (896597)";

 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through Messenger service.

Description :

The remote host is running MSN Messenger.

The version of MSN Messenger used on the remote host is vulnerable
to a remote buffer overflow in the way it handles GIF files (with
height and width fields).
An attacker may exploit this vulnerability to execute arbitrary code
on the remote host.

Solution : 

Microsoft has released a set of patches for MSN Messenger 6.2 :

http://www.microsoft.com/technet/security/bulletin/ms05-022.mspx

Risk factor : 

High / CVSS Base Score : 8 
(AV:R/AC:H/Au:NR/C:C/A:C/I:C/B:N)";


 script_description(english:desc["english"]);

 summary["english"] = "Checks for MS05-022";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);

 script_dependencies("smb_nt_ms04-010.nasl");
 script_require_keys("SMB/Registry/HKLM/SOFTWARE/Classes/Installer/Products/C838BEBA7A1AD5C47B1EB83441062011/Version");
 exit(0);
}


include("smb_func.inc");
include("smb_hotfixes_fcheck.inc");

version =  get_kb_item("SMB/Registry/HKLM/SOFTWARE/Classes/Installer/Products/C838BEBA7A1AD5C47B1EB83441062011/Version");
if ( ! version ) exit(0);

a = ((version) & 0xFF000000) >> 24;
b = ((version & 0xFF0000)) >> 16;
c = version & 0xFFFF;

if ( ( a == 6 ) &&
     ( (b < 2) || ( (b == 2) && (c < 208) ) ) )
   hotfix_security_hole();

