#
# (C) Tenable Network Security
#

if(description)
{
 script_id(23645);
 script_version("$Revision: 1.6 $");

 script_cve_id("CVE-2006-3445");
 script_bugtraq_id(21034);
 
 script_version("$Revision: 1.6 $");
 name["english"] = "Vulnerability in Microsoft Agent Could Remote Code Execution (920213)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

It is possible to execute arbitrary code on the remote host through the
agent service.

Description :

The remote version of Windows contains a flaw in the Microsoft Agent service 
which may allow an attacker to execute arbitrary code on the remote host.

To exploit this flaw, an attacker would need to set up a rogue web site and 
lure a victim on the remote host into visiting it or have him load a malformed
.ACF file.

Solution : 

Microsoft has released a set of patches for Windows 2000, XP and 2003 :

http://www.microsoft.com/technet/security/bulletin/ms06-068.mspx

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 920213";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}


include("smb_hotfixes_fcheck.inc");
include("smb_hotfixes.inc");
include("smb_func.inc");


if ( hotfix_check_sp(xp:3, win2003:2, win2k:6) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( ( hotfix_check_fversion(file:"msagent\Agentsvr.exe", version:"2.0.0.3424") == HCF_OLDER ) ||
      ( hotfix_check_fversion(file:"msagent\Agentsvr.exe", version:"5.2.3790.1242", min_version:"5.2.3790.0") == HCF_OLDER ) )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
else if ( hotfix_missing(name:"920213") > 0 )
	 hotfix_security_hole();


