#
# (C) Tenable Network Security
#

if(description)
{
 script_id(24329);
 script_version("$Revision: 1.5 $");
 script_cve_id("CVE-2006-3448");
 script_bugtraq_id(22484);
 script_xref(name:"OSVDB", value:"31883");

 name["english"] = "Vulnerability in Step-by-Step Interactive Training Could Allow Remote Code Execution (923723)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the training
software.

Description :

The remote host is running a version of Microsoft Step-by-Step Interactive 
Training which contains a flaw which may lead to remote code execution.

To exploit this flaw, an attacker would need to trick a user on the remote host
into opening a malformed file with the affected application.

Solution : 

Microsoft has released a patch :

http://www.microsoft.com/technet/security/bulletin/ms07-005.mspx

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of MRUN32.exe";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");


if ( ! get_kb_item("SMB/WindowsVersion") ) exit(1);

if ( hotfix_check_fversion(file:"mrun32.exe", version:"3.4.1.102") == HCF_OLDER ) hotfix_security_hole();

hotfix_check_fversion_end();
