#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25167);
 script_version("$Revision: 1.5 $");

 script_cve_id("CVE-2007-0940");
 script_bugtraq_id(23782);
 script_xref(name:"OSVDB", value:"34397");

 name["english"] = "Vulnerability in CAPICOM Could Allow Remote Code Execution (931906)";


 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the web browser.

Description :

The remote host is running a version of the CAPICOM library (Cryptographic 
API Component Object Model) which is subject to a flaw which may allow 
arbitrary code to be run.

An attacker may use this to execute arbitrary code on this host.

To exploit this flaw, an attacker would need to set up a rogue web site and 
lure a victim on the remote host into visiting it.

Solution : 

Microsoft has released a set of patches for CAPICOM :

http://www.microsoft.com/technet/security/bulletin/ms07-028.mspx

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of CAPICOM.dll";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

if (!get_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain);
if (rc != 1) 
{
  NetUseDel();
  exit(0);
}


# Determine where it's installed.
keys = make_list(
	"SOFTWARE\Classes\CAPICOM.Certificates\CLSID",
	"SOFTWARE\Classes\CAPICOM.Certificates.1\CLSID",
	"SOFTWARE\Classes\CAPICOM.Certificates.2\CLSID",
	"SOFTWARE\Classes\CAPICOM.Certificates.3\CLSID"
	);

foreach key (keys)
{
 rc = NetUseAdd(share:"IPC$");
 if (rc != 1) 
 {
  NetUseDel();
  exit(0);
 }

 # Connect to remote registry.
 hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
 if (isnull(hklm)) 
 {
   NetUseDel();
   exit(0);
 }


 value = NULL;

 key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
 if (!isnull(key_h))
 {
  value = RegQueryValue(handle:key_h, item:NULL);
  if (!isnull(value))
  {  
   value = value[1];
   RegCloseKey(handle:key_h);

   key_h = RegOpenKey(handle:hklm, key:"SOFTWARE\Classes\CLSID\"+value+"\InprocServer32", mode:MAXIMUM_ALLOWED);
   if (!isnull(key_h))
   {
    value = RegQueryValue(handle:key_h, item:NULL);
    if (!isnull(value))
      value = value[1];
   }
   else
     value = NULL;
  }

  RegCloseKey(handle:key_h);
 }

 RegCloseKey(handle:hklm);
 NetUseDel (close:FALSE);
 
 if (!isnull(value))
 {
  value = str_replace(string:value, find:'"', replace:"");

  share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:value);
  dll =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1", string:value);

  r = NetUseAdd(share:share);
  if ( r != 1 ) 
  {
   NetUseDel();
   exit(1);
  }

  handle = CreateFile (file:dll, desired_access:GENERIC_READ, file_attributes:FILE_ATTRIBUTE_NORMAL, share_mode:FILE_SHARE_READ, create_disposition:OPEN_EXISTING);

  if ( ! isnull(handle) )
  {
   v = GetFileVersion(handle:handle);
   CloseFile(handle:handle);
   if ( !isnull(v) ) 
   {
    if ( ( v[0] < 2)  ||
       ( v[0] == 2 && v[1] < 1 ) ||
       ( v[0] == 2 && v[1] == 1 && v[2] == 0 && v[3] < 2 ) )
    {
     hotfix_security_hole();
     exit(0);
    }
   }
  }
 }

 NetUseDel(close:FALSE);
}

NetUseDel();

