#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25487);
 script_version("$Revision: 1.6 $");

 script_cve_id("CVE-2006-2111", "CVE-2007-1658", "CVE-2007-2225", "CVE-2007-2227");
 script_bugtraq_id(17717, 23103, 24392, 24410);
 script_xref(name:"OSVDB", value:"25073");

 name["english"] = "Cumulative Security Update for Outlook Express and Windows Mail (929123)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the email
client. 

Description:

The remote host is running a version of Microsoft Outlook Express
which contains several security flaws which may allow an attacker to execute
arbitrary code on the remote host. 

To exploit this flaw, an attacker would need to send a malformed 
email to a victim on the remote host and have him open it. 

Solution : 

Microsoft has released a set of patches for Outlook Express and Windows Mail : 

See: http://www.microsoft.com/technet/security/bulletin/ms07-034.mspx

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 929123";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}



include("smb_hotfixes_fcheck.inc");
include("smb_hotfixes.inc");
include("smb_func.inc");


if ( hotfix_check_sp(xp:3, win2003:3, vista:1) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"6.0", sp:0, file:"Inetcomm.dll", version:"6.0.6000.16480", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.2", sp:2, file:"Inetcomm.dll", version:"6.0.3790.4073", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.2", sp:1, file:"Inetcomm.dll", version:"6.0.3790.2929", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.1", sp:2, file:"Inetcomm.dll", version:"6.0.2900.3138", dir:"\system32")  )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
