#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25690);
 #script_bugtraq_id();
 script_version("$Revision: 1.5 $");
 script_cve_id("CVE-2007-3028", "CVE-2007-0040");
 script_bugtraq_id(24796, 24800);
 name["english"] = "Vulnerability in Windows Active Directory Could Allow Remote Code Execution (926122)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

It is possible to execute code on the remote host.

Description :

The remote version of Active Directory contains a flaw in the LDAP
request handler code which may allow an attacker to execute code
on the remote host.
On Windows 2000 an anonymous attacker can exploit this flaw by sending
a specially crafted LDAP packet.
On Windows 2003 valid credentials are needed to exploit it.

Additionally the Active Directory is vulnerable to a remote Denial of
Service Vulnerability.

Solution : 

Microsoft has released a set of patches for Windows 2000 and 2003:

http://www.microsoft.com/technet/security/bulletin/ms07-039.mspx

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 926122";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_hotfixes_fcheck.inc");
include("smb_hotfixes.inc");
include("smb_func.inc");

if ( hotfix_check_sp(win2003:3, win2k:6) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"5.2", sp:1, file:"ntdsa.dll", version:"5.2.3790.2926", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.2", sp:2, file:"ntdsa.dll", version:"5.2.3790.4070", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.0", file:"ntdsa.dll", version:"5.0.2195.7135", dir:"\system32") )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
else if ( hotfix_missing(name:"926122") > 0 &&
	  hotfix_missing(name:"946538") > 0 )
  hotfix_security_hole();


