#
# (C) Tenable Network Security
#

if(description)
{
 script_id(28183);
 script_version("$Revision: 1.4 $");

 script_cve_id("CVE-2007-3896");
 script_bugtraq_id(25945);

 name["english"] = "Vulnerability in Windows URI Handling Could Allow Remote Code Execution (943460)";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Vulnerabilities in the Windows Shell may allow a user to elevate his
privileges.

Description :

The remote version of Windows contains a version of the Windows Shell
which contains a vulnerability in the way it handles URI.

An attacker might use this flaw to execute arbitrary commands on the remote
host using attack vectors such as IE or other tools.


Solution : 

Microsoft has released a set of patches for Windows XP and 2003 :

http://www.microsoft.com/technet/security/bulletin/ms07-061.mspx

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the presence of update 943460";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_func.inc");
include("smb_hotfixes.inc");
include("smb_hotfixes_fcheck.inc");


if ( hotfix_check_sp(xp:3, win2003:3) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( hotfix_is_vulnerable (os:"5.2", sp:2, file:"shell32.dll", version:"6.0.3790.4184", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.2", sp:1, file:"shell32.dll", version:"6.0.3790.3033", dir:"\system32") ||
      hotfix_is_vulnerable (os:"5.1", sp:2, file:"shell32.dll", version:"6.0.2900.3241", dir:"\system32") )
      hotfix_security_hole();
 hotfix_check_fversion_end(); 
}
else if ( hotfix_missing(name:"943460") > 0 ) hotfix_security_hole();
