#
# (C) Tenable Network Security
#

if(description)
{
 script_id(29310);
 script_version("$Revision: 1.5 $");

 script_cve_id("CVE-2007-5350");
 script_bugtraq_id(26757);
 script_xref(name:"OSVDB", value:"39124");

 name["english"] = "Vulnerability in Windows Kernel Could Allow Elevation of Privilege (943078)";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

A local user can elevate his privileges on the remote host.

Description :

The remote host contains a version of the Windows kernel which is vulnerable
to a security flaw which may allow a local user to elevate his privileges
or to crash it (therefore causing a denial of service).

Solution : 

Microsoft has released a set of patches for Windows Vista:

http://www.microsoft.com/technet/security/bulletin/ms07-066.mspx

Risk factor : 

High / CVSS Base Score : 7.2
(CVSS2#AV:L/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the remote registry for 943078";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("smb_hotfixes_fcheck.inc");
include("smb_hotfixes.inc");
include("smb_func.inc");


if ( hotfix_check_sp(vista:1) <= 0 ) exit(0);

if (is_accessible_share())
{
 if ( 
      hotfix_is_vulnerable (os:"6.0", sp:0, file:"Ntoskrnl.exe", version:"6.0.6000.16575", dir:"\System32") ||
      hotfix_is_vulnerable (os:"6.0", sp:0, file:"Ntoskrnl.exe", version:"6.0.6000.20697", min_version:"6.0.6000.20000", dir:"\System32")     )
   hotfix_security_hole();
 
 hotfix_check_fversion_end(); 
 exit (0);
}
