#
# (C) Tenable Network Security
#

 desc["english"] = "
Synopsis :

The remote system has the latest service pack installed.

Description :

By reading the registry key HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\CSDVersion
it was possible to determine the Service Pack version of the Windows 2003
system.

Risk factor :

None";


if(description)
{
 script_id(17662);
 script_version ("$Revision: 1.25 $");
 script_cve_id("CVE-1999-0662", "CVE-2007-1537");
 script_bugtraq_id(12969, 12972, 13008, 23025);
 script_xref(name:"OSVDB", value:"33628");
 
 name["english"] = "SMB Registry : Windows 2003 Server SP2";
 
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the remote SP";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_reg_service_pack.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}

port = get_kb_item("SMB/transport");
if(!port)port = 139;

win = get_kb_item("SMB/WindowsVersion"); 
if (!win) exit(0);

sp = get_kb_item("SMB/CSDVersion");

if(win == "5.2" )
{
 if ( ereg(pattern:"Service Pack 1", string:sp) )
 {
  set_kb_item(name:"SMB/Win2003/ServicePack", value:sp);
  report = string (desc_warn["english"],
		"\n\nPlugin output :\n\n",
		"The remote Windows 2003 system has ",sp," applied, however Service Pack 2 is available\n");
  security_note(data:report, port:port);
  exit(0);
 }
 else if ( ereg(pattern:"Service Pack [2-9]", string:sp) )
 {
  set_kb_item(name:"SMB/Win2003/ServicePack", value:sp);

  report = string (desc["english"],
		"\n\nPlugin output :\n\n",
		"The remote Windows 2003 system has ",sp," applied.\n");

  security_note(data:report, port:port);
  exit(0);
 }
}
