#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  This script is released under the GNU GPL v2
#
# BHO X http://computercops.biz/clsid.php?type=5 update 27012005
#
#
# Tenable grants a special exception for this plugin to use the library 
# 'smb_func.inc'. This exception does not apply to any modified version of 
# this plugin.
#


if(description)
{
 script_id(16314);
 script_version("$Revision: 1.8 $");

 name["english"] = "Potentially unwanted software";

 script_name(english:name["english"]);
 
 desc["english"] = "
This script checks for the presence of files and programs which 
might have been installed without the consent of the user of the
remote host.

Verify each of softwares found to see if they are compliant with
you security policy.
	
Solution : See the URLs which will appear in the report
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of differents dll on the remote host";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005 David Maciejak and Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");
if ( get_kb_item("SMB/samba") ) exit(0);

global_var handle, name, url, key, exp, items;


port = kb_smb_transport();
if(!port)exit(0);

if(!get_port_state(port))return(FALSE);
login = kb_smb_login();
pass  = kb_smb_password();
domain = kb_smb_domain();

soc = open_sock_tcp(port);
if(!soc)exit(0);

session_init(socket:soc, hostname:kb_smb_name());
ret = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if ( ret != 1 ) exit(0);

handle = RegConnectRegistry(hkey:HKEY_CLASS_ROOT);
if ( isnull(handle) ) exit(0);


function check_reg(name, url, key, item, exp)
{
  local_var key_h, value, sz, report;


  key_h = RegOpenKey(handle:handle, key:key, mode:MAXIMUM_ALLOWED);
  if( ! isnull(key_h) )
  {
    value = RegQueryValue(handle:key_h, item:item);
    RegCloseKey(handle:key_h);
    if ( ! isnull(value) ) sz = value[1]; 
    else return 0;
  }
  else return 0;
  
 if(exp == NULL || tolower(exp) >< tolower(sz))
 {
  report = string(
"'", name, "' is installed on the remote host.\n",
"Make sure that the user of the remote host intended to install
this software and that its use matches your corporate security
policy.\n\n",
"Solution : ", url, "\n",
"Risk factor : High");
 
  security_hole(port:kb_smb_transport(), data:report);
 }
}

i = 0;

########################################################################

function fill_names()
{
 local_var files, n, i, j;

 name = make_list();
 url  = make_list();
 key  = make_list();
 items  = make_list();
 exp = make_list();
files = split(keep:FALSE, _FCT_ANON_ARGS[0]);

n = max_index(files);
i = 0;
for ( j = 0 ;  j < n ;  i ++ )
{
 if ( !(files[j] =~ "^NAME" &&
      files[j+1] =~ "^URL" &&
      files[j+2] =~ "^KEY" &&
      files[j+3] =~ "^ITEM" &&
      files[j+4] =~ "^EXP") )
	{
	display("Error at line ", j,"\n");
	break;
	}
  name[i]	= files[j++] - "NAME=";
  url[i]	= files[j++] - "URL=";
  key[i]	= files[j++] - "KEY=";
  items[i] = files[j++] - "ITEM=";
  exp[i]   = files[j++] - "EXP=";
 }
}





##################################################


RegCloseKey(handle:handle);


rootfile = hotfix_get_systemroot();
if ( ! rootfile ) exit(0);

NetUseDel(close:FALSE);
share =  ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:rootfile); 
r = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if ( r != 1 )
{
 NetUseDel();
 exit(1);
}



fill_names("NAME=Commonname toolbar
URL=http://www.doxdesk.com/parasite/CommonName.html
KEY=CLSID\{00000000-0000-0000-0000-000000000000}\InprocServer32
ITEM=
EXP=CnbarIE.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html
KEY=CLSID\{00000000-0000-0000-0000-000000000000}\InprocServer32
ITEM=
EXP=msxmlpp.dll
NAME=AutoSearch
URL=http://www.doxdesk.com/parasite/AutoSearch.html
KEY=CLSID\{00000000-0000-0000-0000-000000000001}\InprocServer32
ITEM=
EXP=safesearch.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html
KEY=CLSID\{00000000-0000-0000-0000-000000000001}\InprocServer32
ITEM=
EXP=msxmlfilt.dll
NAME=ClearSearch
URL=http://doxdesk.com/parasite/ClearSearch.html
KEY=CLSID\{00000000-0000-0000-0000-000000000221}\InprocServer32
ITEM=
EXP=CSIE.DLL
NAME=ClearSearch
URL=http://doxdesk.com/parasite/ClearSearch.html
KEY=CLSID\{00000000-0000-0000-0000-000000000240}\InprocServer32
ITEM=
EXP=IE_ClrSch.dll
NAME=ClearSearch
URL=http://doxdesk.com/parasite/ClearSearch.html
KEY=CLSID\{00000000-0000-0000-0000-000000002230}\InprocServer32
ITEM=
EXP=Csbb.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{00000000-0000-0000-8835-3EFF76BF2657}\InprocServer32
ITEM=
EXP=kw3eef76.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{00000000-0000-0000-BFA1-D7EE6696B865}\InprocServer32
ITEM=
EXP=icdd7ee6.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{00000000-0000-41a3-98CF-00000000168B}\InprocServer32
ITEM=
EXP=wm41a398.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{00000000-0000-47c5-A90F-2CDE8F7638DB}\InprocServer32
ITEM=
EXP=iel2cde8.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0000-5DFC-5652-1705043F6518}\InprocServer32
ITEM=
EXP=audiosrv32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0000-7EBF-57C6-0BAE047EA682}\InprocServer32
ITEM=
EXP=autodisc32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0001-0345-2280-0287F27A63EE}\InprocServer32
ITEM=
EXP=Browserad.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0001-1DBE-075A-39EC04BD88AF}\InprocServer32
ITEM=
EXP=Avicap32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0001-F7A6-1F38-0204019E355E}\InprocServer32
ITEM=
EXP=Asferror32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0002-53D4-0622-35EA0235778E}\InprocServer32
ITEM=
EXP=Ati2dvaa32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0008-D357-0798-004401965D4A}\InprocServer32
ITEM=
EXP=apphelp32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0009-1C42-7D61-6CFF050894A7}\InprocServer32
ITEM=
EXP=avisynthEx32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0015-BD9C-263A-493001BA0C6C}\InprocServer32
ITEM=
EXP=asycfilt32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-002B-EFE6-6B08-560C01922D3B}\InprocServer32
ITEM=
EXP=Apcups32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0033-C1AC-0E62-0C1F0537605D}\InprocServer32
ITEM=
EXP=aviwrap32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-008C-1E65-6AA6-3A270279F027}\InprocServer32
ITEM=
EXP=Ati2dvag32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-00FA-71ED-4ABA-348801BAA0A9}\InprocServer32
ITEM=
EXP=Athprxy32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-08C8-8E68-587B-61F804EE6164}\InprocServer32
ITEM=
EXP=avisynth32.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-0C95-B1F8-547A-405204D6961A}\InprocServer32
ITEM=
EXP=avifile32.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{00000000-10D6-4e5f-8F7F-29B32C1C0FC4}\InprocServer32
ITEM=
EXP=icddefff.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-1530-70F0-6420-4C2701B37263}\InprocServer32
ITEM=
EXP=asfsipc32.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{00000000-167B-41bc-95FF-86A07B14712C}\InprocServer32
ITEM=
EXP=he3bbcff.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{00000000-2565-4c5b-A455-A74C8A2247AB}\InprocServer32
ITEM=
EXP=wmcbaaca.dll
NAME=TX 4 BrowserAd adware
URL=
KEY=CLSID\{00000000-387E-9D50-0079-1744044CB22A}\InprocServer32
ITEM=
EXP=authz32.dll
NAME=VX2 Respondmiter, Blackstone Transponder
URL=http://www.doxdesk.com/parasite/Transponder.html
KEY=CLSID\{00000000-5eb9-11d5-9d45-009027c14662}\InprocServer32
ITEM=
EXP=ehelper.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{00000000-64C4-4a64-9767-895AB4921E41}\InprocServer32
ITEM=
EXP=ielcaabe.dll
NAME=iMesh
URL=http://www.spyany.com/program/article_spw_rm_IMesh.html
KEY=CLSID\{00000000-6CB0-410C-8C3D-8FA8D2011D0A}\InprocServer32
ITEM=
EXP=iMeshBHO.dll
NAME=Transponder parasite variant
URL=http://www.doxdesk.com/parasite/Transponder.html
KEY=CLSID\{00000000-C1EC-0345-6EC2-4D0300000000}\InprocServer32
ITEM=
EXP=ZServ.dll
NAME=AdBreak
URL=http://www.doxdesk.com/parasite/AdBreak.html 
KEY=CLSID\{00000000-D9E3-4BC6-A0BD-3D0CA4BE5271}\InprocServer32
ITEM=
EXP=Fhfmm.dll
NAME=Transponder variant
URL=http://www.webhelper4u.com/transponder/btgrab.html
KEY=CLSID\{00000000-F09C-02B4-6EC2-AD0300000000}\InprocServer32
ITEM=
EXP=BTGrab.dll
NAME=DyFuCa/Internet Optimizer
URL=http://www.doxdesk.com/parasite/InternetOptimizer.html
KEY=CLSID\{00000010-6F7D-442C-93E3-4A4827C2E4C8}\InprocServer32
ITEM=
EXP=nem219.dll
NAME=Adware.Ramdud
URL=
KEY=CLSID\{00000015-A527-34E7-25C2-03A4E313B2E9}\InprocServer32
ITEM=
EXP=winsrvs_1.dll
NAME=aBetterinternet/Transponder variant
URL=http://doxdesk.com/parasite/Transponder.html 
KEY=CLSID\{00000026-8735-428D-B81F-DD098223B25F}\InprocServer32
ITEM=
EXP=speer.dll
NAME=aBetterinternet/Transponder
URL=http://doxdesk.com/parasite/Transponder.html
KEY=CLSID\{00000049-8F91-4D9C-9573-F016E7626484}\InprocServer32
ITEM=
EXP=ceres.dll
NAME=FavoriteMan
URL=http://www.doxdesk.com/parasite/FavoriteMan.html 
KEY=CLSID\{000000DA-0786-4633-87C6-1AA7A4429EF1}\InprocServer32
ITEM=
EXP=emesx.dll
NAME=FavoriteMan/FOne
URL=http://www.doxdesk.com/parasite/FavoriteMan.html 
KEY=CLSID\{000000F1-34E3-4633-87C6-1AA7A44296DA}\InprocServer32
ITEM=
EXP=FOne.dll
NAME=SmartBrowser
URL=http://www.doxdesk.com/parasite/SmartBrowser.html
KEY=CLSID\{00000185-B716-11D3-92F3-00D0B709A7D8}\InprocServer32
ITEM=
EXP=BHO.0.1.0
NAME=SmartBrowser
URL=http://www.doxdesk.com/parasite/SmartBrowser.html
KEY=CLSID\{00000185-C745-43D2-44F1-01A1C789C738}\InprocServer32
ITEM=
EXP=BHO.0.1.0
NAME=Transponder parasite variant
URL=http://webhelper4u.com/transponders/freephone.html
KEY=CLSID\{00000250-0320-4DD4-BE4F-7566D2314352}\InprocServer32
ITEM=
EXP=VoiceIP.dll
NAME=Transponder
URL=http://www.doxdesk.com/parasite/Transponder.html 
KEY=CLSID\{0000026A-8230-4DD4-BE4F-6889D1E74167}\InprocServer32
ITEM=
EXP=Tps108.dll
NAME=Transponder
URL=http://www.doxdesk.com/parasite/Transponder.html 
KEY=CLSID\{00000273-8230-4DD4-BE4F-6889D1E74167}\InprocServer32
ITEM=
EXP=host.dll
NAME=IPInsight
URL=http://www.doxdesk.com/parasite/IPInsight.html 
KEY=CLSID\{000004CC-E4FF-4F2C-BC30-DBEF0B983BC9}\InprocServer32
ITEM=
EXP=Ipinsigt.dll
NAME=VX2 Transponder variant
URL=http://www.doxdesk.com/parasite/Transponder.html 
KEY=CLSID\{00000580-C637-11D5-831C-00105AD6ACF0}\InprocServer32
ITEM=
EXP=Msview.dll
NAME=VX2.aBetterInternet
URL=http://www.doxdesk.com/parasite/Transponder.html 
KEY=CLSID\{000006B1-19B5-414A-849F-2A3C64AE6939}\InprocServer32
ITEM=
EXP=bi.dll
NAME=SideSearch
URL=http://doxdesk.com/parasite/Sidesearch.html
KEY=CLSID\{00000762-3965-4A1A-98CE-3D4BF457D4C8}\InprocServer32
ITEM=
EXP=sidesearch.dll
NAME=FavoriteMan
URL=http://www.doxdesk.com/parasite/FavoriteMan.html
KEY=CLSID\{00000EF1-0786-4633-87C6-1AA7A44296DA}\InprocServer32
ITEM=
EXP=ATPartners.dll
NAME=FavoriteMan
URL=http://www.doxdesk.com/parasite/FavoriteMan.html 
KEY=CLSID\{00000EF1-34E3-4633-87C6-1AA7A44296DA}\InprocServer32
ITEM=
EXP=F1.dll
NAME=TwainTech adware
URL=http://www.pchell.com/support/twaintec.shtml
KEY=CLSID\{000020DD-C72E-4113-AF77-DD56626C6C42}\InprocServer32
ITEM=
EXP=twaintec.dll
NAME=TwainTech adware
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453078844
KEY=CLSID\{0000607D-D204-42C7-8E46-216055BF9918}\InprocServer32
ITEM=
EXP=mxTarget.dll
NAME=AdsStore adware
URL=http://research.sunbelt-software.com/threatdisplay.aspx?name=AdsStore&threatid=1717
KEY=CLSID\{00010a21-b924-4cd6-893c-eea1071ae8b3}\InprocServer32
ITEM=
EXP=PCDBS.DLL
NAME=SearchFast parasite
URL=http://doxdesk.com/parasite/Searchfst.html
KEY=CLSID\{000277A3-7D84-406a-9799-D12A81594693}\InprocServer32
ITEM=
EXP=srchfst.dll
NAME=SearchEnhancement hijacker
URL=http://www.doxdesk.com/parasite/SCBar.html
KEY=CLSID\{00041A26-7033-432C-94C7-6371DE343822}\InprocServer32
ITEM=
EXP=scbar.dll
NAME=ShopNav variant
URL=http://www.doxdesk.com/parasite/ShopNav.html
KEY=CLSID\{0007522A-2297-43C1-8EB1-C90B0FF20DA5}\InprocServer32
ITEM=
EXP=enhtb.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{000E6ED5-E3FC-4c93-99E9-D38D2A9F9B09}\InprocServer32
ITEM=
EXP=he3e3fc4.dll
NAME=NetPal
URL=http://www.doxdesk.com/parasite/NetPal.html
KEY=CLSID\{000E7270-CC7A-0786-8E7A-DA09B51938A6}\InprocServer32
ITEM=
EXP=n3tpa1.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{00110011-4B0B-44D5-9718-90C88817369B}\InprocServer32
ITEM=
EXP=NavExt.dll
NAME=BookedSpace
URL=http://www.doxdesk.com/parasite/BookedSpace.html
KEY=CLSID\{0019C3E2-DD48-4A6D-AB2D-8D32436313D9}\InprocServer32
ITEM=
EXP=oo4.dll
NAME=BookedSpace variant
URL=http://www.doxdesk.com/parasite/BookedSpace.html
KEY=CLSID\{0019C3E2-DD48-4A6D-ABCD-8D32436313D9}\InprocServer32
ITEM=
EXP=bxsx5.dll
NAME=BookedSpace variant
URL=http://www.doxdesk.com/parasite/BookedSpace.html
KEY=CLSID\{0019C3E2-DD48-4A6D-ABCD-8D32436323D9}\InprocServer32
ITEM=
EXP=bxxs5.dll
NAME=WebSearch
URL=http://www.spywareguide.com/product_show.php?id=505
KEY=CLSID\{001DAE60-95C0-11d3-924E-009027950886}\InprocServer32
ITEM=
EXP=Spotonbh.dll
NAME=AtHoc Toolbar
URL=http://www.athoc.com/site/products/portalToolbar.asp
KEY=CLSID\{001F2470-5DF5-11d3-B991-00A0C9BB0874}\InprocServer32
ITEM=
EXP=AtHocTBr.DLL
NAME=MultiMPP.com adware
URL=http://www.multimpp.com/
KEY=CLSID\{002EB272-2590-4693-B166-FBD5D9B6FEA6}\InprocServer32
ITEM=
EXP=multimpp.dll
NAME=Transponder parasite variant
URL=http://www.doxdesk.com/parasite/Transponder.html
KEY=CLSID\{00320615-B6C2-40A6-8F99-F1C52D674FAD}\InprocServer32
ITEM=
EXP=localNRD.dll
NAME=Naupoint toolbar
URL=http://doxdesk.com/parasite/Naupoint.html
KEY=CLSID\{0036F389-FEF8-43AC-9220-16430E0012ED}\InprocServer32
ITEM=
EXP=iEBINST.dll
NAME=Malware taking advantage of the ASN.1 exploit
URL=http://www.us-cert.gov/cas/techalerts/TA04-041A.html
KEY=CLSID\{00673769-777F-4814-BE0F-74CBA1D823B8}\InprocServer32
ITEM=
EXP=Iehook.dll
NAME=Adware.Slagent
URL=http://securityresponse.symantec.com/avcenter/venc/data/trojan.simcss.b.html
KEY=CLSID\{008DB894-99ED-445D-8547-0E7C9808898D}\InprocServer32
ITEM=
EXP=4b_1,0,1,2_mslagent.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{00A0A40C-F432-4C59-BA11-B25D142C7AB7}\InprocServer32
ITEM=
EXP=2IN
NAME=MyTotalSearch
URL=http://www.doxdesk.com/parasite/MySearch.html
KEY=CLSID\{00BD2861-C654-4694-A44A-98642D73247D}\InprocServer32
ITEM=
EXP=MTSSRCAS.DLL
NAME=IncrediFind variant
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{00D6A7E7-4A97-456f-848A-3B75BF7554D7}\InprocServer32
ITEM=
EXP=PerfectNavBHO.dll
NAME=FastFind.org SubSearch
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453074896
KEY=CLSID\{00F16DC8-1B2A-42F4-B18B-E21DA9D2D7FD}\InprocServer32
ITEM=
EXP=01A00.DLL
NAME=PolyFilter
URL=
KEY=CLSID\{0140DF95-9128-4053-AE72-F43F0CFCA062}\InprocServer32
ITEM=
EXP=SiKernel.dll
NAME=ExactSearch or MySearch
URL=http://www.doxdesk.com/parasite/eXactSearch.html http://doxdesk.com/parasite/MySearch.html
KEY=CLSID\{014DA6C1-189F-421a-88CD-07CFE51CFF10}\InprocServer32
ITEM=
EXP=eXacttoolbar.dll
NAME=Apropos Adware
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-AproposMedia.aspx
KEY=CLSID\{016235BE-59D4-4CEB-ADD5-E2378282A1D9}\InprocServer32
ITEM=
EXP=CxtPls.dll
NAME=Enhancemysearch.com keyword hijacker
URL=
KEY=CLSID\{017C20C1-F86F-11D8-9B25-000ACD002AE3}\InprocServer32
ITEM=
EXP=Helper100.dll
NAME=Incredifind/Keenvalue
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{0199DF25-9820-4bd5-9FEE-5A765AB4371E}\InprocServer32
ITEM=
EXP=IncFindBHO170.dll
NAME=PeopleOnPage/AproposMedia
URL=http://www.doxdesk.com/parasite/AproposMedia.html 
KEY=CLSID\{01C5BF6C-E699-4CD7-BEA1-786FA05C83AB}\InprocServer32
ITEM=
EXP=AproposPlugin.dll
NAME=IncrediFind/Keenvalue
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{01CD4DDA-166D-4831-A373-ACCC27E1BB9D}\InprocServer32
ITEM=
EXP=IncFindBHO150c.dll
NAME=IEPlugin variant
URL=http://www.doxdesk.com/parasite/IEPlugin.html
KEY=CLSID\{01F44A8A-8C97-4325-A378-76E68DC4AB2E}\InprocServer32
ITEM=
EXP=systb.dll
NAME=unknown malware
URL=http://www.virit.com/startup/scheda.asp?num=21
KEY=CLSID\{01FB9C55-FC66-4476-A199-389241193188}\InprocServer32
ITEM=
EXP=dll
NAME=Adware.Slagent
URL=http://securityresponse.symantec.com/avcenter/venc/data/trojan.simcss.b.html
KEY=CLSID\{021BB032-80A8-4FB6-B3D5-CF27B1553B95}\InprocServer32
ITEM=
EXP=4b_1,0,1,0_mslagent.dll
NAME=Adlogix InPop
URL=
KEY=CLSID\{024DE5EB-3649-445E-8D57-C09A9A33D479}\InprocServer32
ITEM=
EXP=phelper.dll
NAME=Adware.LizardBar
URL=http://sarc.com/avcenter/venc/data/adware.lizardbar.html
KEY=CLSID\{029BB53A-C312-4b09-9B4F-ED57AF027B28}\InprocServer32
ITEM=
EXP=winhlp32.dll
NAME=VirtuMonde adware variant Vundo
URL=http://securityresponse.symantec.com/avcenter/venc/data/trojan.vundo.html
KEY=CLSID\{02F96FB7-8AF6-439B-B7BA-2F952F9E4800}\InprocServer32
ITEM=
EXP=dat
NAME=Trojan.Downloader.Domcom.A
URL=
KEY=CLSID\{031B6D43-CBC4-46A5-8E46-CF8B407C1A33}\InprocServer32
ITEM=
EXP=ipreg32.dll
NAME=Muul.com SiteHistory  hijacker
URL=
KEY=CLSID\{0345B059-8731-42BC-B7B7-5121014B02C6}\InprocServer32
ITEM=
EXP=ChangeURL_30.dll
NAME=TOPicks
URL=http://www.doxdesk.com/parasite/TOPicks.html 
KEY=CLSID\{0352960F-47BE-11D5-AB93-00D0B760B4EB}\InprocServer32
ITEM=
EXP=Htcheck2.dll
NAME=SmartPops
URL=http://www.kephyr.com/spywarescanner/library/smartpops/index.phtml
KEY=CLSID\{0421701D-CF13-4E70-ADF0-45A953E7CB8B}\InprocServer32
ITEM=
EXP=RH.dll
NAME=IncrediFind variant
URL=http://www.doxdesk.com/parasite/KeenValue.html 
KEY=CLSID\{0428FFC7-1931-45b7-95CB-3CBB919777E1}\InprocServer32
ITEM=
EXP=PerfectNavBHO.dll
NAME=unidentified hijacker
URL=
KEY=CLSID\{044D9F9F-0EE0-4E9B-B89B-5EBCA0F852CC}\InprocServer32
ITEM=
EXP=fsearchbar.dll
NAME=Actual Names (AdvSearch) Internet Keywords
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453072513
KEY=CLSID\{046D6EA4-15E3-4b27-8010-45BD78A9219E}\InprocServer32
ITEM=
EXP=inetkw.dll
NAME=Excite Search bar
URL=http://www.excite.com/ 
KEY=CLSID\{04719991-296F-4958-AA0F-FA25FFA5008B}\InprocServer32
ITEM=
EXP=X8bar.dll
NAME=Icoo Loader
URL=http://www.by-users.co.uk/forums/?board=help&action=display&num=1085918311
KEY=CLSID\{0519A9C9-064A-4cbc-BC47-D0EACD581477}\InprocServer32
ITEM=
EXP=icooue.dll
NAME=ShopForGood/Marketdart
URL=http://www.kephyr.com/spywarescanner/library/shopforgood/index.phtml 
KEY=CLSID\{05BBB56A-2A69-4A5C-BFDA-43295DD67434}\InprocServer32
ITEM=
EXP=Winy.dll
NAME=StickyPops.com adware
URL=
KEY=CLSID\{06594350-D723-11D8-9669-0800200C9A66}\InprocServer32
ITEM=
EXP=DNSProxy.dll
NAME=Zy web search hijacker
URL=
KEY=CLSID\{06CAD548-14DD-4fa3-9EA9-05F83C18CBD7}\InprocServer32
ITEM=
EXP=MSPXS32.DLL
NAME=7FaSSt /7Search
URL=http://www.doxdesk.com/parasite/7FaSSt.html 
KEY=CLSID\{06DFEDAA-6196-11D5-BFC8-00508B4A487D}\InprocServer32
ITEM=
EXP=7Search.dll
NAME=Spyware.BrowserAccel
URL=http://securityresponse.symantec.com/avcenter/venc/data/spyware.browseraccel.html
KEY=CLSID\{074E3AA7-7718-4404-B3F8-FF8FB5414E0E}\InprocServer32
ITEM=
EXP=BrowserAccelerator.dll
NAME=Advanced Searchbar
URL=http://www.spynet.com/spyware/spyware-Advanced-Searchbar.aspx
KEY=CLSID\{07531599-F255-4050-B96E-ECE5AA2E63A5}\InprocServer32
ITEM=
EXP=AdvancedBar.dll
NAME=Superlogy.com search hijacker
URL=
KEY=CLSID\{08227B4B-54FE-4C4D-809F-BCA46292FC5B}\InprocServer32
ITEM=
EXP=Zedd4.dll
NAME=SideStep
URL=http://www.doxdesk.com/parasite/SideStep.html 
KEY=CLSID\{08351226-6472-43BD-8A40-D9221FF1C4CE}\InprocServer32
ITEM=
EXP=SbCIe026.dll
NAME=SideStep
URL=http://www.doxdesk.com/parasite/SideStep.html
KEY=CLSID\{08351227-6472-43BD-8A40-D9221FF1C4CE}\InprocServer32
ITEM=
EXP=SbCIe027.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html
KEY=CLSID\{086AE192-23A6-48D6-96EC-715F53797E85}\InprocServer32
ITEM=
EXP=DReplace.dll
NAME=TrafficHog, iLookup variant
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{086CEFD5-A88D-4981-8915-D51F04360ED1}\InprocServer32
ITEM=
EXP=winalot32.dll
NAME=BrowserAid/SearchandClick
URL=http://www.kephyr.com/spywarescanner/library/browseraid/index.phtml
KEY=CLSID\{087173EF-9829-4F49-8340-A524177D3F60}\InprocServer32
ITEM=
EXP=inetp60.dll
NAME=Linkz.com AdBlock
URL=http://www.castlecops.com/tk89-APHelper_Class.html
KEY=CLSID\{08C63920-DC18-11D2-9E1E-00A0247061AB}\InprocServer32
ITEM=
EXP=Aphelper.dll
NAME=Friends.fr. toolbar
URL=http://research.sunbelt-software.com/threatdisplay.aspx?threatid=47429
KEY=CLSID\{08DBDE36-DF28-11D5-8CA5-0050DA44A764}\InprocServer32
ITEM=
EXP=Msvri.dll
NAME=Trojan.Clicker.Delf.ai
URL=http://research.sunbelt-software.com/threatdisplay.aspx?threatid=47211
KEY=CLSID\{08DF42F3-792D-4944-941B-512582B87219}\InprocServer32
ITEM=
EXP=adobeacr.dll
NAME=iWon Search Assistant
URL=http://www.doxdesk.com/parasite/Aornum.html
KEY=CLSID\{08E1C8E1-E565-44fc-A766-C9539BB3ABB7}\InprocServer32
ITEM=
EXP=I1srchas.dll
NAME=Grip Toolbar
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-Grip-Toolbar.aspx
KEY=CLSID\{08F46458-D00F-4573-8EB3-A9A9E15503F8}\InprocServer32
ITEM=
EXP=NetGuideBHO170.dll
NAME=MyTotalSearch
URL=http://www.doxdesk.com/parasite/MySearch.html
KEY=CLSID\{094176F1-BF35-4bcb-B68A-108DFB8C3825}\InprocServer32
ITEM=
EXP=MTSBAR.DLL
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html 
KEY=CLSID\{0982868C-47F0-4EFB-A664-C7B0B1015808}\InprocServer32
ITEM=
EXP=Newads~1.dll
NAME=Adware.IAGold
URL=http://sarc.com/avcenter/venc/data/adware.iagold.html
KEY=CLSID\{0A1A2A3A-4A5A-6A7A-8A9A-AABACADAEAFA}\InprocServer32
ITEM=
EXP=dll
NAME=HuntBar/Stoolbar
URL=http://www.doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{0A5CF411-F0BF-4AF8-A2A4-8233F3109BED}\InprocServer32
ITEM=
EXP=Stoolbar.dll
NAME=HuntBar
URL=http://www.doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{0A68C5A2-64AE-4415-88A2-6542304A4745}\InprocServer32
ITEM=
EXP=Msiets.dll
NAME=Sexxxpassport.com browser plugin
URL=
KEY=CLSID\{0A7E7249-89E4-4FBF-B256-04DC8F8BAD69}\InprocServer32
ITEM=
EXP=Spp3.dll
NAME=Thesearchmall, iLookup variant
URL=http://www.doxdesk.com/parasite/ILookup.htm
KEY=CLSID\{0AEE4D0C-4B38-4196-AE32-70ACE5656647}\InprocServer32
ITEM=
EXP=winsrm32.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{0B519E07-7824-4adc-8890-93D5EABBF285}\InprocServer32
ITEM=
EXP=msadocm32.dll
NAME=Adlogix.com Zamingo adware
URL=http://www.spyany.com/program/article_adw_rm_Zamingo.html
KEY=CLSID\{0B90AA1B-F649-44C3-9FD3-736C332CBBCF}\InprocServer32
ITEM=
EXP=IEEnhancer.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html 
KEY=CLSID\{0BA1C6EB-D062-4E37-9DB5-B07743276324}\InprocServer32
ITEM=
EXP=ms****.dll
NAME=SBSoft/EZFinder.com hijacker
URL=http://www.castlecops.com/tk1385-uns_dll.html
KEY=CLSID\{0CA6C3EA-2054-4011-BC9F-8BBC017A169C}\InprocServer32
ITEM=
EXP=uns.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{0D7DC475-59EB-4781-985F-A6F5D4E2BC73}\InprocServer32
ITEM=
EXP=Lie1D6Ff.dll
NAME=BrowserAid/FeaturedResults
URL=http://www.doxdesk.com/parasite/BrowserAid.html 
KEY=CLSID\{0DDBB570-0396-44C9-986A-8F6F61A51C2F}\InprocServer32
ITEM=
EXP=Msiefr40.dll
NAME=Deltabar : Deltaclick
URL=http://support.microsoft.com/?kbid=316770 
KEY=CLSID\{0FC817C2-3B45-11D4-8340-0050DA825906}\InprocServer32
ITEM=
EXP=DeltaClick.dll
NAME=Whazit
URL=http://www.doxdesk.com/parasite/Whazit.html 
KEY=CLSID\{10955232-B671-11D7-8066-0040F6F477E4}\InprocServer32
ITEM=
EXP=whattn.dll
NAME=CnsMin
URL=http://www.doxdesk.com/parasite/CnsMin.html
KEY=CLSID\{118CE65F-5D86-4AEA-A9BD-94F92B89119F}\InprocServer32
ITEM=
EXP=CnsMinIdn.dll
NAME=Sexxxpassport.com browser plugin
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453079935
KEY=CLSID\{11904CE8-632A-4856-A7CC-00B33FE71BD8}\InprocServer32
ITEM=
EXP=Spp3.dll
NAME=SearchSquire
URL=http://www.doxdesk.com/parasite/SearchSquire.html 
KEY=CLSID\{11990E9F-2A4D-11D6-9507-02608CDD2842}\InprocServer32
ITEM=
EXP=SearchSquire.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{12D02C08-218F-4A11-BDE1-6611ADB7B81F}\InprocServer32
ITEM=
EXP=sys32_app.dll
NAME=Winpage Blocker
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453079932
KEY=CLSID\{12DF6E3E-6272-4AE8-880B-2158D60791C0}\InprocServer32
ITEM=
EXP=WinPage.dll
NAME=BrowserAid/Startium variant
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{12EE7A5E-0674-42f9-A76A-000000004D00}\InprocServer32
ITEM=
EXP=stlb2.dll
NAME=ActiveSearch/411Ferret
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453088053
KEY=CLSID\{12F02779-6D88-4958-8AD3-83C12D86ADC7}\InprocServer32
ITEM=
EXP=toolbar.dll
NAME=SuperBar
URL=http://www.doxdesk.com/parasite/SuperBar.html
KEY=CLSID\{136A9D1D-1F4B-43D4-8359-6F2382449255}\InprocServer32
ITEM=
EXP=Superbar.dll
NAME=FavoriteMan
URL=http://www.doxdesk.com/parasite/FavoriteMan.html
KEY=CLSID\{139D88E5-C372-469D-B4C5-1FE00852AB9B}\InprocServer32
ITEM=
EXP=ofrg.dll
NAME=p0rn related
URL=
KEY=CLSID\{13F90341-AD79-4A9F-9B57-0234675670D6}\InprocServer32
ITEM=
EXP=Ipsysdrv32.dll
NAME=StickyPops.com adware
URL=
KEY=CLSID\{1433F750-E53F-11D8-9669-0800200C9A66}\InprocServer32
ITEM=
EXP=STRAd32.dll
NAME=ShopNavSearch/Srng
URL=http://www.doxdesk.com/parasite/Srng.html 
KEY=CLSID\{14B3D246-6274-40B5-8D50-6C2ADE2AB29B}\InprocServer32
ITEM=
EXP=Snhelper.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{150FA160-130D-451F-B863-B655061432BA}\InprocServer32
ITEM=
EXP=mgs_32.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{166348F1-2C41-4C9F-86BB-EB2B8ADE030C}\InprocServer32
ITEM=
EXP=msvrfy
NAME=Comet Cursor
URL=http://www.doxdesk.com/parasite/CometCursor.html
KEY=CLSID\{1678F7E1-C422-11D0-AD7D-00400515CAAA}\InprocServer32
ITEM=
EXP=comet.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{17DA0C9E-4A27-4ac5-BB75-5D24B8CDB972}\InprocServer32
ITEM=
EXP=Excel10.dll
NAME=Spyware.DigitalNames variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/spyware.digitalnames.html
KEY=CLSID\{183D5161-0C62-4295-896C-44E7442CD6F2}\InprocServer32
ITEM=
EXP=DigitalNamesPlugIn150.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{18722863-6D1D-4300-BF29-406948EDA7CB}\InprocServer32
ITEM=
EXP=dat
NAME=I-Lookup
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{18B79968-1A76-4953-9EBB-B651407F8998}\InprocServer32
ITEM=
EXP=winenc32.dll
NAME=i-lookup/Sbus
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{19A447BA-9C2E-4864-93F5-A0645229771E}\InprocServer32
ITEM=
EXP=Sbus.dll
NAME=SearchEx
URL=http://www.doxdesk.com/parasite/Searchex.html
KEY=CLSID\{1A98BCA2-0BD1-47DE-9710-C7665F7F1FCB}\InprocServer32
ITEM=
EXP=Iebrw.dll
NAME=CnsMin
URL=http://www.aluriasoftware.com/spyware-removal/details/CnsMin/
KEY=CLSID\{1B0E7716-898E-48cc-9690-4E338E8DE1D3}\InprocServer32
ITEM=
EXP=Assist.dll
NAME=Clickspring/PurityScan
URL=http://doxdesk.com/parasite/PurityScan.html
KEY=CLSID\{1B7D753B-1981-4bd2-91F3-6D055EE113A0}\InprocServer32
ITEM=
EXP=NDrv.dll
NAME=Browserplugin.com malware
URL=
KEY=CLSID\{1BDD55B8-3985-4E59-B906-5E0AD56D6710}\InprocServer32
ITEM=
EXP=WH
NAME=Adware.IEPageHelper
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453083026
KEY=CLSID\{1C4DA27D-4D52-4465-A089-98E01BB725CA}\InprocServer32
ITEM=
EXP=inetdctr.dll
NAME=iSearch toolbar
URL=http://www.kephyr.com/spywarescanner/library/isearch/index.phtml
KEY=CLSID\{1C78AB3F-A857-482e-80C0-3A1E5238A565}\InprocServer32
ITEM=
EXP=toolbar.dll
NAME=SpiderSearch, iLookup variant
URL=
KEY=CLSID\{1D022C27-3771-4D1D-B1B7-1953E271C6CA}\InprocServer32
ITEM=
EXP=winsps32.dll
NAME=BlazeFind/SearchRelevancy hijacker
URL=
KEY=CLSID\{1D7E3B41-23CE-469B-BE1B-A64B877923E1}\InprocServer32
ITEM=
EXP=SearchRelevancy.dll
NAME=SubSearch v22
URL=http://www.doxdesk.com/parasite/SubSearch.html
KEY=CLSID\{1D870C86-AA3C-4451-81E4-71D480A1A652}\InprocServer32
ITEM=
EXP=SbSrch_V22.dll
NAME=NJStar Asian Explorer
URL=http://www.njstar.com/asianexplorer/
KEY=CLSID\{1E1B2879-30C7-11D4-8DDF-525400E483E3}\InprocServer32
ITEM=
EXP=ETop100.dll
NAME=Backdoor.Lixy.B
URL=http://www.symantec.com/avcenter/venc/data/backdoor.lixy.b.html
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-000000000003}\InprocServer32
ITEM=
EXP=SSocks5.dll
NAME=Backdoor.Lixy.B
URL=http://www.symantec.com/avcenter/venc/data/backdoor.lixy.b.html
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-000000000004}\InprocServer32
ITEM=
EXP=Ssocks32.dll
NAME=Clitor
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453079921
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-123457123457}\InprocServer32
ITEM=
EXP=Explorer.dll
NAME=unidentified adware
URL=
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-D7ACAC31337F}\InprocServer32
ITEM=
EXP=Mslink32.dll
NAME=BackDoor Lixy
URL=http://securityresponse.symantec.com/avcenter/venc/data/backdoor.lixy.html
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-D7ACAC95951A}\InprocServer32
ITEM=
EXP=Lid.dll
NAME=Commonname toolbar
URL=http://www.doxdesk.com/parasite/CommonName.html
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-D7ACAC95951F}\InprocServer32
ITEM=
EXP=CnbarIE.dll
NAME=CooolWebSearch parasite variant
URL=http://www.spywareinfo.com/~merijn/cwschronicles.html
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-D7ACAC95951F}\InprocServer32
ITEM=
EXP=DNSErr.dll
NAME=GoGoTools
URL=http://doxdesk.com/parasite/GogoTools.html parasite
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-D7ACAC95951F}\InprocServer32
ITEM=
EXP=HTMLEdit.dll
NAME=p0rn related
URL=
KEY=CLSID\{1E1B2879-88FF-11D2-8D96-D7ACAC97972F}\InprocServer32
ITEM=
EXP=Msudp.dll
NAME=Personal Antispy keylogger
URL=http://www.botspot.com/Intelligent_Agent/2235.html
KEY=CLSID\{1E1B2879-88FF-11D3-8D96-D7ACAC95951A}\InprocServer32
ITEM=
EXP=Funnywb.dll
NAME=QuickFlicks Streaming Player
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453073164
KEY=CLSID\{1E6F1D6A-1F20-11D4-8859-00A0CCE26836}\InprocServer32
ITEM=
EXP=SVAplayer.dll
NAME=ToolbarCC
URL=http://www.doxdesk.com/parasite/ToolbarCC.html
KEY=CLSID\{1F48AA48-C53A-4E21-85E7-AC7CC6B5FFA2}\InprocServer32
ITEM=
EXP=dll
NAME=ToolbarCC/Rnd
URL=http://www.doxdesk.com/parasite/ToolbarCC.html
KEY=CLSID\{1F48AA48-C53A-4E21-85E7-AC7CC6B5FFA7}\InprocServer32
ITEM=
EXP=win
NAME=ToolbarCC/Rnd
URL=http://www.doxdesk.com/parasite/ToolbarCC.html
KEY=CLSID\{1F48AA48-C53A-4E21-85E7-AC7CC6B5FFA8}\InprocServer32
ITEM=
EXP=win
NAME=ToolbarCC/Rnd
URL=http://www.doxdesk.com/parasite/ToolbarCC.html 
KEY=CLSID\{1F48AA48-C53A-4E21-85E7-AC7CC6B5FFAF}\InprocServer32
ITEM=
EXP=dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{1F48AA48-C53A-4E21-85E7-AC7CC6B5FFB1}\InprocServer32
ITEM=
EXP=MS
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{1F48AA48-C53A-4E21-85E7-AC7CC6B5FFB2}\InprocServer32
ITEM=
EXP=MS
NAME=i-lookup/Abeb
URL=http://www.doxdesk.com/parasite/ILookup.html 
KEY=CLSID\{2038A287-4221-4F76-A7C0-ADDD77AFABB3}\InprocServer32
ITEM=
EXP=abeb.dll
NAME=Myaopop Adware
URL=
KEY=CLSID\{204E9F8F-38CA-4E11-BA91-06B685285CC0}\InprocServer32
ITEM=
EXP=xpllog.dll
NAME=HotBar
URL=http://www.doxdesk.com/parasite/HotBar.html
KEY=CLSID\{204F937E-519E-4597-96FA-8F1F59F3CB6D}\InprocServer32
ITEM=
EXP=ctor.dll
NAME=Give4Free
URL=
KEY=CLSID\{208E7E77-507A-4649-B0C9-D39E9049C7A2}\InprocServer32
ITEM=
EXP=ibho.dll
NAME=CustomToolbar
URL=http://www.doxdesk.com/parasite/CustomToolbar.html 
KEY=CLSID\{21301D69-B8F1-46AA-B0B5-09EE2285914C}\InprocServer32
ITEM=
EXP=CustomToolbar.dll
NAME=SearchEnhancement hijacker
URL=http://groups.google.com/groups?q=searchenhancement&hl=en&lr=&ie=UTF-8&oe=UTF-8&selm=5fa201c33b6c%24abac7a20%243101280a%40phx.gbl&rnum=1 
KEY=CLSID\{22941A26-7033-432C-94C7-6371DE343822}\InprocServer32
ITEM=
EXP=Scbar.dll
NAME=hijacker,  as yet unidentified
URL=
KEY=CLSID\{22B9A67D-E689-44B6-B775-0E8FE84B4F9B}\InprocServer32
ITEM=
EXP=dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{2316230A-C89C-4BCC-95C2-66659AC7A775}\InprocServer32
ITEM=
EXP=dat
NAME=Expext/MetaDirect hijacker
URL=http://www.securemost.com/articles/trou_3_remove_expext.htm
KEY=CLSID\{23BC1CCF-4BE7-497F-B154-6ADA68425FBB}\InprocServer32
ITEM=
EXP=expext.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{25F7FA20-3FC3-11D7-B487-00D05990014C}\InprocServer32
ITEM=
EXP=ms
NAME=Xupiter
URL=http://www.doxdesk.com/parasite/Xupiter.html
KEY=CLSID\{2662BDD7-05D6-408F-B241-FF98FACE6054}\InprocServer32
ITEM=
EXP=Xtupdate.dll
NAME=Whazit
URL=http://www.doxdesk.com/parasite/Whazit.html
KEY=CLSID\{267D5BD3-0DC2-4724-A196-7F4794FBB9EB}\InprocServer32
ITEM=
EXP=outones.dll
NAME=eUniverse/Keenvalue variant
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{269B6797-664E-48AA-B283-B012BDF6E525}\InprocServer32
ITEM=
EXP=BHO.dll
NAME=WurldMedia
URL=http://www.doxdesk.com/parasite/WurldMedia.html
KEY=CLSID\{2737A6C0-7E24-11D7-B299-00E0297E0844}\InprocServer32
ITEM=
EXP=
NAME=WhistleSoftware
URL=http://www.uslocalweather.com/privacy.asp
KEY=CLSID\{27557cf1-a237-496d-8c8f-08f3844c6a8b}\InprocServer32
ITEM=
EXP=WhistleHelper.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{275636E4-A535-4668-9FF1-86DC0C62D446}\InprocServer32
ITEM=
EXP=msopt.dll
NAME=MyPageFinder
URL=http://www.doxdesk.com/parasite/MyPageFinder.html
KEY=CLSID\{27A5FF76-9919-492C-98E3-EDA3502FC829}\InprocServer32
ITEM=
EXP=ml_32.dll
NAME=SearchMiracle.EliteBar
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-SearchMiracle.EliteBar.aspx
KEY=CLSID\{28CAEFF3-0F18-4036-B504-51D73BD81ABC}\InprocServer32
ITEM=
EXP=EliteToolBar version 53.dll
NAME=EliteBar/SearchMiracle adware
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-SearchMiracle.EliteBar.aspx
KEY=CLSID\{28CAEFF3-0F18-4036-B504-51D73BD81C3A}\InprocServer32
ITEM=
EXP=Elitebar.dll
NAME=Searchportal.info - CoolWebSearch parasite variant
URL=http://www.spywareinfo.com/~merijn/cwschronicles.html
KEY=CLSID\{28F65FCB-D130-11D8-BA48-8BE0C49AF370}\InprocServer32
ITEM=
EXP=popup_bl.dll
NAME=unidentified hijacker
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453073363
KEY=CLSID\{29A38549-AF6F-11D4-89D6-BC1DFD912B00}\InprocServer32
ITEM=
EXP=bho1.dll
NAME=Commander toolbar
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453083035
KEY=CLSID\{29F7B7FA-ADC8-48ea-9E1C-EA87A05AE642}\InprocServer32
ITEM=
EXP=sbb.dll
NAME=FastFind.org SubSearch
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453074896
KEY=CLSID\{2A57772A-D963-4533-A999-A4D66B7EF424}\InprocServer32
ITEM=
EXP=00S00.dll
NAME=Make-deal.com malware
URL=
KEY=CLSID\{2A7B720A-7A28-4e99-80A0-2DF985EC93D0}\InprocServer32
ITEM=
EXP=Font.dll
NAME=SmartShopper
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-Hotbar.ShoppingReports.aspx
KEY=CLSID\{2A8A997F-BB9F-48F6-AA2B-2762D50F9289}\InprocServer32
ITEM=
EXP=smrtshpr.dll
NAME=LookThru Cool Search Bar
URL=
KEY=CLSID\{2AF8CED6-5BD8-4310-A90C-9664EFB16B10}\InprocServer32
ITEM=
EXP=coolbar.dll
NAME=BookedSpace/Remanent
URL=http://www.doxdesk.com/parasite/BookedSpace.html
KEY=CLSID\{2B3452C5-1B9A-440F-A203-F6ED0F64C895}\InprocServer32
ITEM=
EXP=rem00001.dll
NAME=Dynamic Desktop Media adware
URL=http://www.spyany.com/program/article_spw_rm_Dynamic_Desktop_Media.html
KEY=CLSID\{2BC43670-C0BD-4794-BB11-F60F3E001DC5}\InprocServer32
ITEM=
EXP=ddmp.dll
NAME=IESearch Toolbar
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-IESearchToolbar.aspx
KEY=CLSID\{2c5175a2-adf3-4f57-ab70- ba90fd60a383}\InprocServer32
ITEM=
EXP=IESEARCHTOOLBAR.DLL
NAME=IESearch toolbar hijacker
URL=
KEY=CLSID\{2C5175A2-ADF3-4F57-AB70-BA90FD60A383}\InprocServer32
ITEM=
EXP=IESearchToolbar.dll
NAME=BrowserAid/Startium
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{2CF0B992-5EEB-4143-99C0-5297EF71F443}\InprocServer32
ITEM=
EXP=stlbdist.dll
NAME=BrowserAid/Startium
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{2CF0B992-5EEB-4143-99C0-5297EF71F444}\InprocServer32
ITEM=
EXP=stlbdist.dll
NAME=BrowserAid/Startium
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{2CF0B992-5EEB-4143-99C0-5297EF71F44A}\InprocServer32
ITEM=
EXP=stlbad123.dll
NAME=BrowserAid/Startium
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{2CF0B992-5EEB-4143-99C2-5297EF71F44A}\InprocServer32
ITEM=
EXP=stlbad123.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{2D38A51A-23C9-48a1-A33C-48675AA2B494}\InprocServer32
ITEM=
EXP=winres.dll
NAME=i-lookup/Drbr
URL=http://www.doxdesk.com/parasite/ILookup.html 
KEY=CLSID\{2D556983-83D7-4630-9AA5-27C74CA27B79}\InprocServer32
ITEM=
EXP=Drbr.dll
NAME=AdBlaster Adware
URL=http://www.spyany.com/program/article_adw_rm_AdBlaster.html
KEY=CLSID\{2D7CB618-CC1C-4126-A7E3-F5B12D3BCF71}\InprocServer32
ITEM=
EXP=ngpw34.dll
NAME=GoGoData toolbar
URL=http://gogodata.com/toolbar/index.htm
KEY=CLSID\{2D877C0B-3F44-42CD-A283-57AAA9186CB9}\InprocServer32
ITEM=
EXP=GoGoDataBar.dll
NAME=VX2.aBetterInternet variant
URL=
KEY=CLSID\{2DC9D850-144D-11E1-B3C9-10805E499D95}\InprocServer32
ITEM=
EXP=mplay32.dll
NAME=InetSpeak
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{2E12B523-3D4C-4FAC-9B04-0376A8F5E879}\InprocServer32
ITEM=
EXP=WindowsIE.dll
NAME=FastFind adware variant
URL=http://www.trendmicro.com/vinfo/virusencyclo/default5.asp?VName=TROJ_STARTPAG.KF&VSect=T
KEY=CLSID\{2E65A557-173C-4DE9-860B-28FC5CACA542}\InprocServer32
ITEM=
EXP=Setup.dll
NAME=P0rn related
URL=
KEY=CLSID\{2E77E33F-671E-4334-ABAA-0C2E2BE654F1}\InprocServer32
ITEM=
EXP=mdv_32.dll
NAME=SubmitHook
URL=http://www.lurhq.com/submithook.html
KEY=CLSID\{2E9CAFF6-30C7-4208-8807-E79D4EC6F806}\InprocServer32
ITEM=
EXP=Submithook.dll
NAME=ezSearching
URL=http://doxdesk.com/parasite/ezSearching.html
KEY=CLSID\{2F24B54D-3A27-11D8-8169-00C02623048A}\InprocServer32
ITEM=
EXP=Testadit3.dll
NAME=Porn Hijacker
URL=
KEY=CLSID\{2FF5573C-0EB5-43db-A1B2-C4326813468E}\InprocServer32
ITEM=
EXP=iehr.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{30192F8D-0958-44E6-B54D-331FD39AC959}\InprocServer32
ITEM=
EXP=toolband.dll
NAME=SBSoft IWantSearch hijacker
URL=http://sarc.com/avcenter/venc/data/adware.iwantsearch.html
KEY=CLSID\{30192F8D-0958-44E6-B54D-331FD39AC959}\InprocServer32
ITEM=
EXP=rundlg32.dll
NAME=SBSoft Web-Search hijacker variant, a member of the CoolWebSearch parasite family
URL=http://sarc.com/avcenter/venc/data/adware.iwantsearch.html
KEY=CLSID\{30192F8D-0958-44E6-B54D-331FD39AC959}\InprocServer32
ITEM=
EXP=webdlg32.dll
NAME=EZtracks/Pickoftheweb toolbar
URL=
KEY=CLSID\{3023AF97-870E-476A-B30E-3923DF2B84BD}\InprocServer32
ITEM=
EXP=eztracks_ieplug.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{30279F2D-1A38-4785-97D4-5C3508BDB289}\InprocServer32
ITEM=
EXP=dat
NAME=Adware.OpenSite
URL=http://sarc.com/avcenter/venc/data/adware.opensite.html
KEY=CLSID\{30A56549-9D5B-4D34-AFA7-440A7F0538A9}\InprocServer32
ITEM=
EXP=Opnste.dll
NAME=ProBot Activity Monitor
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453076611
KEY=CLSID\{312FA154-E1B7-4336-9833-EE6B38D58B56}\InprocServer32
ITEM=
EXP=pbcommon.dll
NAME=SubSearch v22
URL=http://www.doxdesk.com/parasite/SubSearch.html
KEY=CLSID\{31995C64-CB4D-483E-82C2-CCFFE2F66CAB}\InprocServer32
ITEM=
EXP=msvcn.dll
NAME=ezSearching
URL=http://www.doxdesk.com/parasite/ezSearching.html
KEY=CLSID\{34D516EA-40E3-4E3B-8BA8-505112738ED5}\InprocServer32
ITEM=
EXP=ctavp3.dll
NAME=i-Lookup/Chgrgs
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{35CC7369-C6EB-4A64-AB05-44CF0B5087A0}\InprocServer32
ITEM=
EXP=Chgrgs.dll
NAME=E2Give
URL=http://www.doxdesk.com/parasite/E2Give.html
KEY=CLSID\{3643ABC2-21BF-46B9-B230-F247DB0C6FD6}\InprocServer32
ITEM=
EXP=IeBHOs.dll
NAME=Burnaby Module >e-card_viewer
URL=http://www.symantec.com/avcenter/venc/data/ortyc.trojan.html
KEY=CLSID\{3750BFA3-1392-4AF3-AF86-9D2D4776E5A4}\InprocServer32
ITEM=
EXP=potd.dll
NAME=Oasisnet.com Hijacker/web downloader
URL=
KEY=CLSID\{37A5FF76-9919-492C-98E3-EDA3502FC829}\InprocServer32
ITEM=
EXP=Oasis.dll
NAME=InetSpeak/Iexplorr
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{388D7EBB-CBB9-4126-8DB2-86DC6863A206}\InprocServer32
ITEM=
EXP=iexplorr11.dll
NAME=BookedSpace
URL=http://www.doxdesk.com/parasite/BookedSpace.html
KEY=CLSID\{392BE62B-E7DE-430A-8859-0AFE677DE6E1}\InprocServer32
ITEM=
EXP=bs2.dll
NAME=Hijacker, as yet unidentified
URL=
KEY=CLSID\{397D7D63-816E-4ECF-8761-775C932C5CF1}\InprocServer32
ITEM=
EXP=iDonate.dll
NAME=InetSpeak/Iexplorr
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{39AF31DD-EAFC-45EA-A56C-385B52E25CC0}\InprocServer32
ITEM=
EXP=iexplorr22.dll
NAME=WurldMedia
URL=http://www.doxdesk.com/parasite/WurldMedia.html
KEY=CLSID\{3A279869-C6B6-4410-A041-0435DE6AD916}\InprocServer32
ITEM=
EXP=M030106SHOP.DLL
NAME=Wishbone Toolbar
URL=http://www.wishbonemedia.com/products.html
KEY=CLSID\{3AA90BC2-58C0-4F4D-A87C-2C6F3D3CD5FE}\InprocServer32
ITEM=
EXP=Minst.dll
NAME=LZIO.com adware
URL=http://www.spywareguide.com/product_show.php?id=853
KEY=CLSID\{3BC2C2D1-758E-4912-BED2-AE50DE69E8AF}\InprocServer32
ITEM=
EXP=iedcb1f5.dll
NAME=Alexa
URL=http://www.safersite.com/PestInfo/a/Alexa_Toolbar.asp
KEY=CLSID\{3DF73DF8-41E2-4fc2-8CBF-4B9407433755}\InprocServer32
ITEM=
EXP=lxTB.dll
NAME=porn hijacker
URL=
KEY=CLSID\{3E307D7F-5F68-4ddb-9294-EE230950F60C}\InprocServer32
ITEM=
EXP=winacl.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{3EC8E271-FAB9-418a-8A8E-65AEB4029E64}\InprocServer32
ITEM=
EXP=dat
NAME=Traffix Inc/iMatchup
URL=http://www.webhelper4u.com/transponders/potwbar.html
KEY=CLSID\{3F68A524-6E47-44E6-9FE7-795EABFA3B36}\InprocServer32
ITEM=
EXP=traffix1.1.0.25.dll
NAME=Not yet identified malware
URL=
KEY=CLSID\{40205287-E793-41AC-B95C-D8D064BA33CA}\InprocServer32
ITEM=
EXP=mscfg.dll
NAME=WurldMedia/bpboh
URL=http://www.doxdesk.com/parasite/WurldMedia.html
KEY=CLSID\{40AC4D2D-491D-11D4-AAF2-0008C75DCD2B}\InprocServer32
ITEM=
EXP=Bpboh.dll
NAME=Popmonster adware
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453078833
KEY=CLSID\{4209B4C1-1295-4908-9312-A53C036EB3CD}\InprocServer32
ITEM=
EXP=BHO.dll
NAME=PBar
URL=http://www.pbar.net/?id=BAFDJFFBBEdDBEZKVCSKL
KEY=CLSID\{42132494-F48F-4187-ABC8-0F343AD2E465}\InprocServer32
ITEM=
EXP=Pbshmd.dll
NAME=Dyfuca/Internet Optimizer
URL=http://www.doxdesk.com/parasite/InternetOptimizer
KEY=CLSID\{432D8C41-8586-11D8-997D-00C026232EB9}\InprocServer32
ITEM=
EXP=bvm202.dll
NAME=LoveTester foistware
URL=http://spamwatch.codefish.net.au/modules.php?op=modload&name=News&file=index&catid=&topic=24
KEY=CLSID\{43FA5935-E36E-4937-8127-A90191B2EC68}\InprocServer32
ITEM=
EXP=domain11.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{441354C5-911B-409B-9A66-A11D6D4E1A22}\InprocServer32
ITEM=
EXP=sdmtb.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{446CF8A5-617E-4D91-95AE-AE78CE0D06AF}\InprocServer32
ITEM=
EXP=dat
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{447160CD-ECF5-4EA2-8A8A-1F70CA363F85}\InprocServer32
ITEM=
EXP=bundle
NAME=Msinfosys/AutoSearch hijacker
URL=http://www.doxdesk.com/parasite/AutoSearch.html
KEY=CLSID\{44A23DAB-8D31-43AE-9F68-5AC24CF7CE8C}\InprocServer32
ITEM=
EXP=Msinfosys.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{44E5B409-35A2-4E8D-BF94-344222323A53}\InprocServer32
ITEM=
EXP=dat
NAME=Naupoint toolbar
URL=http://doxdesk.com/parasite/Naupoint.html
KEY=CLSID\{44FD0AF8-9D30-4E96-8ECE-306446B5E0D3}\InprocServer32
ITEM=
EXP=iEBINST2.dll
NAME=Icoo Loader
URL=http://www.by-users.co.uk/forums/?board=help&action=display&num=1085918311
KEY=CLSID\{465A59EC-20E5-4fca-A38A-E5EC3C480218}\InprocServer32
ITEM=
EXP=icoou.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{467FAEB2-5F5B-4c81-BAE0-2A4752CA7F4E}\InprocServer32
ITEM=
EXP=dll
NAME=W32.Aspam.Trojan.B
URL=http://securityresponse.symantec.com/avcenter/venc/data/w32.aspam.trojan.b.html
KEY=CLSID\{499DB658-1909-420B-931A-4A8CAEFD232F}\InprocServer32
ITEM=
EXP=Drvman32.dll
NAME=NewDotNet
URL=http://www.doxdesk.com/parasite/NewDotNet.html
KEY=CLSID\{4A2AACF3-ADF6-11D5-98A9-00E018981B9E}\InprocServer32
ITEM=
EXP=newdotnet
NAME=ezSearching
URL=http://www.doxdesk.com/parasite/ezSearching.html
KEY=CLSID\{4B021269-DD24-48B2-96B4-DA121E9C0502}\InprocServer32
ITEM=
EXP=ctpp
NAME=StartNow/HyperBar
URL=http://www.castlecops.com/tk266-HyperBHO.html
KEY=CLSID\{4B2F5308-2CB0-40E2-8030-59936ED5D22C}\InprocServer32
ITEM=
EXP=Hyperbar.dll
NAME=Adware.Sa
URL=http://sarc.com/avcenter/venc/data/adware.sa.html
KEY=CLSID\{4BCF322B-9621-4e90-9678-F1424EB7584E}\InprocServer32
ITEM=
EXP=Udpmod.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{4C1B116F-2860-46db-8E6C-B4BFC4DFD683}\InprocServer32
ITEM=
EXP=ietlbass32.dll
NAME=SubSearch
URL=http://www.doxdesk.com/parasite/SubSearch.html
KEY=CLSID\{4C4871FD-30F6-4430-8834-BC75D58F1529}\InprocServer32
ITEM=
EXP=Sbsrch_v2.dll
NAME=InetSpeak/Iexplorr
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{4CEBBC6B-5CEE-4644-80CF-38980BAE93F6}\InprocServer32
ITEM=
EXP=Iexplorr23.dll
NAME=Begin2Search bar, iLookup variant
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{4D568F0F-8AC9-40AB-88B7-415134C78777}\InprocServer32
ITEM=
EXP=dll
NAME=Trojan-Clicker.Win32.Delf.bc
URL=
KEY=CLSID\{4E7BD74F-2B8D-469E-85AC-FD60BB9AAE32}\InprocServer32
ITEM=
EXP=seotoolbar.dll
NAME=2020Search
URL=http://www.kephyr.com/spywarescanner/library/2020search/index.phtml
KEY=CLSID\{4E7BD74F-2B8D-469E-92C6-CE7EB590A94D}\InprocServer32
ITEM=
EXP=2020Search2.dll
NAME=Naupoint toolbar
URL=http://doxdesk.com/parasite/Naupoint.html
KEY=CLSID\{4E7BD74F-2B8D-469E-95BE-B378BA9CB52D}\InprocServer32
ITEM=
EXP=Naupointbar.dll
NAME=SearchCentrix adware variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.somatic/index.phtml
KEY=CLSID\{4E7BD74F-2B8D-469E-96F7-EB6DB99AA92E}\InprocServer32
ITEM=
EXP=gssomatic.dll
NAME=SearchCentrix adware variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.somatic/index.phtml
KEY=CLSID\{4E7BD74F-2B8D-469E-98F7-EB6DB99AA93B}\InprocServer32
ITEM=
EXP=ifsomatic.dll
NAME=Push toolbar
URL=
KEY=CLSID\{4E7BD74F-2B8D-469E-A0E8-F76FA694BF2E}\InprocServer32
ITEM=
EXP=searchv2.dll
NAME=Hijacker,  as yet unidentified
URL=
KEY=CLSID\{4E7BD74F-2B8D-469E-A1F6-FC7EB590A97D}\InprocServer32
ITEM=
EXP=search3.dll
NAME=KeenValue/PowerSearch
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-A3EE-FB7FA682AA7D}\InprocServer32
ITEM=
EXP=pwrsdp1.dll
NAME=KeenValue/PowerSearch
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-A3FA-F161A787AD2D}\InprocServer32
ITEM=
EXP=pwrsmnd1.dll
NAME=Grip Toolbar
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-Grip-Toolbar.aspx
KEY=CLSID\{4E7BD74F-2B8D-469E-A4E4-FC7CBD87BD7D}\InprocServer32
ITEM=
EXP=gripcz6.dll
NAME=PowerSearch toolbar
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-A58D-8F6FA787AD2D}\InprocServer32
ITEM=
EXP=PWRSC037.DLL
NAME=SearchCentrix adware variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.wzhelper/index.phtml
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FB-EF60B19DA02A}\InprocServer32
ITEM=
EXP=Wzhelper.dll
NAME=SRNG/ShopNav
URL=http://www.doxdesk.com/parasite/Srng.html
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FB-EF60B19DB42E}\InprocServer32
ITEM=
EXP=SNHelper.dll
NAME=SearchCentrix adware variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.somatic/index.phtml
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FB-EF60B19DBC34}\InprocServer32
ITEM=
EXP=ifhelper.dll
NAME=KeenValue/PowerSearch
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FC-F378A787AD2D}\InprocServer32
ITEM=
EXP=Toolbarpwrstlbr.dll
NAME=eUniverse SirSearch
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FC-F76FA694BF2E}\InprocServer32
ITEM=
EXP=Searchbr.dll
NAME=MegaSearch
URL=http://doxdesk.com/parasite/MegaSearch.html
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FF-FA7FB592BF30}\InprocServer32
ITEM=
EXP=megasear.dll
NAME=Gamebar
URL=http://member.game.net/Membership/Privacy.asp
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FF-FD69B994BD7D}\InprocServer32
ITEM=
EXP=gamebar.dll
NAME=PickOfTheWeb toolbar
URL=http://www.webhelper4u.com/transponders/potwbar.html
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FF-FD7BA09AAA7D}\InprocServer32
ITEM=
EXP=potwbar.dll
NAME=eUniverse SearchNugget Toolbar
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-C0FF-FD7FF4D5FA7D}\InprocServer32
ITEM=
EXP=sbar.dll
NAME=KeenValue/PowerSearch
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-C8FB-FC6DA787AD2D}\InprocServer32
ITEM=
EXP=pwrsacez.dll
NAME=SearchCentrix adware variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.somatic/index.phtml
KEY=CLSID\{4E7BD74F-2B8D-469E-D1F7-EB6DB99AA97D}\InprocServer32
ITEM=
EXP=somatic.dll
NAME=Voonda Toolbar
URL=http://www.castlecops.com/tk1479-tafbar.html
KEY=CLSID\{4E7BD74F-2B8D-469E-D4FF-EB2CF4D5FA7D}\InprocServer32
ITEM=
EXP=taf.dll
NAME=KeenValue/PowerSearch
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-D4FF-ED78A787AD2D}\InprocServer32
ITEM=
EXP=pwrstraf.dll
NAME=SearchCentrix adware variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.webalize/index.phtml
KEY=CLSID\{4E7BD74F-2B8D-469E-D7E4-F660B597BF2A}\InprocServer32
ITEM=
EXP=Webalize.dll
NAME=BrowserVillage Toolbar
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-BrowserVillage-Toolbar.aspx
KEY=CLSID\{4E7BD74F-2B8D-469E-D7F9-FE60B89CAC3F}\InprocServer32
ITEM=
EXP=bvillage.dll
NAME=SearchCentrix variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.mygeek/index.phtml 
KEY=CLSID\{4E7BD74F-2B8D-469E-D9FB-FA6BAD98FA7D}\InprocServer32
ITEM=
EXP=MyGeek.dll - MyGeek/Search-o-Matic2000
NAME=InstaFinder hijacker
URL=
KEY=CLSID\{4E7BD74F-2B8D-469E-DCF7-F96DA086B434}\InprocServer32
ITEM=
EXP=instafin.dll
NAME=SearchCentrix adware variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.mygeek/index.phtml
KEY=CLSID\{4E7BD74F-2B8D-469E-DFF7-EC6BF4D5FA7D}\InprocServer32
ITEM=
EXP=gsim.dll
NAME=KeenValue/Powersearch variant
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4E7BD74F-2B8D-469E-DFF7-EC7DA787AD2D}\InprocServer32
ITEM=
EXP=Pwrsqsim.dll
NAME=404Search
URL=http://doxdesk.com/parasite/404Search.html
KEY=CLSID\{4E7BD74F-2B8D-469E-EEFD-ED6DB186CE4D}\InprocServer32
ITEM=
EXP=404Search.dll
NAME=IncrediFind/Keenvalue
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{4FC95EDD-4796-4966-9049-29649C80111D}\InprocServer32
ITEM=
EXP=incfindbho.dll
NAME=SeekSeek
URL=http://www.trendmicro.com/vinfo/virusencyclo/default5.asp?VName=ADW_SCANPORTAL.A&VSect=T
KEY=CLSID\{5074851C-F67A-488E-A9C9-C244573F4068}\InprocServer32
ITEM=
EXP=iesearch.dll
NAME=AdBars
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453079049
KEY=CLSID\{51641EF3-8A7A-4D84-8659-B0911E947CC8}\InprocServer32
ITEM=
EXP=DownloadHtml.dll
NAME=WurldMedia
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=59272
KEY=CLSID\{525BBD23-1863-46C6-86D6-5F9A3715D44E}\InprocServer32
ITEM=
EXP=mbho.dll
NAME=NetNucleus/Mirar webband
URL=http://www.kephyr.com/spywarescanner/library/mirartoolbar.winnb40/index.phtml
KEY=CLSID\{528DA727-EC08-461E-9564-DF5C971E8574}\InprocServer32
ITEM=
EXP=WinNB40.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{52DC9EC1-35A9-4914-98D9-D568A9854DA2}\InprocServer32
ITEM=
EXP=dll
NAME=DigitalNames spyware related
URL=http://securityresponse.symantec.com/avcenter/venc/data/spyware.digitalnames.html
KEY=CLSID\{531553EB-B210-4116-BC2C-C09608F4193E}\InprocServer32
ITEM=
EXP=SetGlbHO.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{5321E378-FFAD-4999-8C62-03CA8155F0B3}\InprocServer32
ITEM=
EXP=1.00.07.dll
NAME=404Search
URL=http://doxdesk.com/parasite/404Search.html
KEY=CLSID\{53C330D6-A4AB-419B-B45D-FD4411C1FEF4}\InprocServer32
ITEM=
EXP=404Search.dll
NAME=WinAd
URL=http://www.kephyr.com/spywarescanner/library/winad/index.phtml
KEY=CLSID\{53D3C442-8FEE-4784-9A21-6297D39613F0}\InprocServer32
ITEM=
EXP=Winad2.dll
NAME=HighTraffic
URL=http://www.doxdesk.com/parasite/HighTraffic.html
KEY=CLSID\{53E10C2C-43B2-4657-BA29-AAE179E7D35C}\InprocServer32
ITEM=
EXP=BHO2.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{5483427F-93B8-1470-5A89-E6B56484CDB2}\InprocServer32
ITEM=
EXP=
NAME=InetSpeak/Iexplorr
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{54ED9B49-81D1-4866-95A6-30F01DE0047E}\InprocServer32
ITEM=
EXP=iexplorr29.dll
NAME=from imu.com.cn
URL=
KEY=CLSID\{54F8C0E2-34F9-474F-B47F-2CFCFE2300A2}\InprocServer32
ITEM=
EXP=IMULiver.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{55E301E5-BA44-4095-BB0B-14E0123CCF71}\InprocServer32
ITEM=
EXP=dat
NAME=SafeguardProtect/Veevo
URL=http://www.castlecops.com/tk1602-sfg_dll_random_char.html
KEY=CLSID\{564FFB73-9EEF-4969-92FA-5FC4A92E2C2A}\InprocServer32
ITEM=
EXP=sfg_
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{5742F79A-1D91-42c4-990C-B46CF55A6478}\InprocServer32
ITEM=
EXP=setfgi.dll
NAME=Adware.Margoc variant
URL=http://sarc.com/avcenter/venc/data/adware.margoc.html
KEY=CLSID\{57CD6D2E-0291-488F-B846-AF101B367DD5}\InprocServer32
ITEM=
EXP=dll
NAME=Ezula TopText
URL=http://www.cexx.org/toptext.htm
KEY=CLSID\{58359010-BF36-11D3-99A2-0050DA2EE1BE}\InprocServer32
ITEM=
EXP=eabh.dll
NAME=Gratisware
URL=http://www.doxdesk.com/parasite/Gratisware.html
KEY=CLSID\{5843A29E-1246-11D4-BA8C-0050DA707ACD}\InprocServer32
ITEM=
EXP=crs32.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{587DBF2D-9145-4c9e-92C2-1F953DA73773}\InprocServer32
ITEM=
EXP=Iefeatsl.dll
NAME=TotalVelocity zSearch
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453083031
KEY=CLSID\{5886A6DC-AAF4-45E9-979A-8E5E6DEE30E7}\InprocServer32
ITEM=
EXP=zSearch.dll
NAME=JimmySurf
URL=http://www.safer-networking.com/removeJimmySurf.php
KEY=CLSID\{5998B08E-CFAC-11D5-822A-0050048E6E38}\InprocServer32
ITEM=
EXP=SurfPlugin.dll
NAME=WurldMedia
URL=http://www.doxdesk.com/parasite/WurldMedia.html
KEY=CLSID\{5A3A5040-4210-11D7-BD2E-00080E34122F}\InprocServer32
ITEM=
EXP=M030206POHS.DLL
NAME=iSearch Desktop Search toolbar
URL=
KEY=CLSID\{5B4AB8E2-6DC5-477A-B637-BF3C1A2E5993}\InprocServer32
ITEM=
EXP=sysupd.dll
NAME=eSearch browser Hijacker
URL=http://www.vsantivirus.com/troj-startpage-lg.htm
KEY=CLSID\{5C472352-90D0-4214-BF20-8E4A2B82F980}\InprocServer32
ITEM=
EXP=win32app.dll
NAME=IncrediFind/Keenvalue
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{5D60FF48-95BE-4956-B4C6-6BB168A70310}\InprocServer32
ITEM=
EXP=incfindbho.dll
NAME=180solutions
URL=http://www.surfassistant.com/eula.html
KEY=CLSID\{5DAFD089-24B1-4c5e-BD42-8CA72550717B}\InprocServer32
ITEM=
EXP=saiemod.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{5ED50735-B0D9-47C6-9774-02DD8E6FE053}\InprocServer32
ITEM=
EXP=disable.dll
NAME=BrowserAid CashToolbar/QuickLaunch toolbar
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{5F5564AC-DE7A-4DCD-9296-32E71A35DCB6}\InprocServer32
ITEM=
EXP=Browseraidtoolbar.dll
NAME=BrowserPal toolbar
URL=http://www.doxdesk.com/parasite/BrowserPal.html
KEY=CLSID\{5F5564AC-DE7A-4DCD-9296-32E71A35DCB7}\InprocServer32
ITEM=
EXP=bptlb.dll
NAME=Adlogix.com Zamingo adware
URL=http://www.spyany.com/program/article_adw_rm_Zamingo.html
KEY=CLSID\{5FA6752A-C4A0-4222-88C2-928AE5AB4966}\InprocServer32
ITEM=
EXP=SWin32.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{60112085-E1CE-4e0e-823A-EBB1AD98804C}\InprocServer32
ITEM=
EXP=dat
NAME=Naupoint toolbar
URL=http://doxdesk.com/parasite/Naupoint.html
KEY=CLSID\{60261C06-81B0-4DE0-9313-E5BA203A64E9}\InprocServer32
ITEM=
EXP=pdfmgr.dll
NAME=Netpal
URL=http://www.doxdesk.com/parasite/NetPal.html
KEY=CLSID\{6085FB5B-C281-4B9C-8E5D-D2792EA30D2F}\InprocServer32
ITEM=
EXP=Netpal.dll
NAME=iGetNet/Natural Language Navigation
URL=http://www.doxdesk.com/parasite/IGetNet.html
KEY=CLSID\{60E78CAC-E9A7-4302-B9EE-8582EDE22FBF}\InprocServer32
ITEM=
EXP=BHO001.DLL
NAME=i-lookup search bar
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{61D029AC-972B-49FE-A155-962DFA0A37BB}\InprocServer32
ITEM=
EXP=Ineb.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{62160EEF-9D84-4C19-B7B8-6AC2526CD726}\InprocServer32
ITEM=
EXP=dll
NAME=Matrix Technology Network 123Mania
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453094812
KEY=CLSID\{622CC208-B014-4FE0-801B-874A5E5E403A}\InprocServer32
ITEM=
EXP=GIDCAI32.DLL
NAME=CnsMin
URL=http://www.doxdesk.com/parasite/CnsMin.html
KEY=CLSID\{6231D512-E4A4-4DF2-BE62-5B8F0EE348EF}\InprocServer32
ITEM=
EXP=cesweb.dll
NAME=Stingware GuardBar
URL=http://www.guardbar.com/
KEY=CLSID\{62F5BBB6-A71E-46E7-AE78-73D25185EDC8}\InprocServer32
ITEM=
EXP=GuardBar.dll
NAME=Townews.com adware
URL=
KEY=CLSID\{634EFDE4-087D-4ce9-952F-63C9EEB2E0BF}\InprocServer32
ITEM=
EXP=WNDPOS~1.DLL
NAME=Naupoint toolbar
URL=http://doxdesk.com/parasite/Naupoint.html
KEY=CLSID\{6375B3AD-4440-4C1F-95E5-A24198ED671C}\InprocServer32
ITEM=
EXP=sp1.dll
NAME=Huntbar
URL=http://www.doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{63B78BC1-A711-4D46-AD2F-C581AC420D41}\InprocServer32
ITEM=
EXP=Btiein.dll
NAME=FlashTrack, Ftapp
URL=http://www.doxdesk.com/parasite/FlashTrack.html
KEY=CLSID\{63CF97E8-4133-438a-A831-CC9C6D47D673}\InprocServer32
ITEM=
EXP=Flcp.dll
NAME=Win32/Aspam.Trojan
URL=http://www.doxdesk.com/parasite/ASpam.html
KEY=CLSID\{657B9354-BB3B-4500-A9B0-109B4FA64815}\InprocServer32
ITEM=
EXP=amcis32.dll
NAME=Commander Toolbar
URL=
KEY=CLSID\{6596829B-37D4-40ad-971B-1E9041725C52}\InprocServer32
ITEM=
EXP=ietb.dll
NAME=PeopleOnPage/AproposMedia
URL=http://www.doxdesk.com/parasite/AproposMedia.html
KEY=CLSID\{65C8C1F5-230E-4DC9-9A0D-F3159A5E7778}\InprocServer32
ITEM=
EXP=pop
NAME=OpinionBar
URL=http://www.earncashontheinternet.com/paidtosurf/review/opinionbar.asp
KEY=CLSID\{6607C683-AE7C-11D4-ACD7-0050DAC291A2}\InprocServer32
ITEM=
EXP=Myiemonitor.dll
NAME=Commonname toolbar
URL=http://www.doxdesk.com/parasite/CommonName.html
KEY=CLSID\{6656B666-992F-4D74-8588-8CAC9E79D90C}\InprocServer32
ITEM=
EXP=CNBabe.dll
NAME=FlashTrack, Ftapp
URL=http://www.doxdesk.com/parasite/FlashTrack.html
KEY=CLSID\{665ACD90-4541-4836-9FE4-062386BB8F05}\InprocServer32
ITEM=
EXP=F
NAME=LinkReplacer
URL=http://www.doxdesk.com/parasite/LinkReplacer.html
KEY=CLSID\{66993893-61B8-47DC-B10D-21E0C86DD9C8}\InprocServer32
ITEM=
EXP=iehelper.dll
NAME=Whazit
URL=http://www.doxdesk.com/parasite/Whazit.html
KEY=CLSID\{66F67511-2665-4C34-9E20-FAC2C0954EF2}\InprocServer32
ITEM=
EXP=whattt.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{68132581-10F2-416E-B188-4E648075325A}\InprocServer32
ITEM=
EXP=dat
NAME=PrecisionPop adware
URL=http://sarc.com/avcenter/venc/data/adware.precisionpop.html
KEY=CLSID\{68513770-A18E-11D7-B77C-00C0DFF3F600}\InprocServer32
ITEM=
EXP=Helper.dll
NAME=IEplugin
URL=http://www.doxdesk.com/parasite/IEPlugin.html
KEY=CLSID\{69135BDE-5FDC-4B61-98AA-82AD2091BCCC}\InprocServer32
ITEM=
EXP=systb.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{6A06CDAD-9D2D-42A0-9C91-C0CF7CB9971B}\InprocServer32
ITEM=
EXP=dat
NAME=LinkReplacer hijacker variant
URL=http://www.doxdesk.com/parasite/LinkReplacer.html
KEY=CLSID\{6A6E50DC-BFA8-4B40-AB1B-159E03E829FD}\InprocServer32
ITEM=
EXP=lmf32.dll
NAME=eAcceleration StopSign
URL=http://www.doxdesk.com/parasite/DownloadReceiver.html
KEY=CLSID\{6ACD11BD-4CA0-4283-A8D8-872B9BA289B6}\InprocServer32
ITEM=
EXP=webcbrowse.dll
NAME=Alexa Toolbar
URL=http://pages.alexa.com/prod_serv/quicktour_new.html
KEY=CLSID\{6AF9BC61-3CC5-42A7-82D1-FFC2562A7289}\InprocServer32
ITEM=
EXP=Alxie328.dll
NAME=InetSpeak/Iexplorr
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{6B12DABB-0B7C-44FA-B0B3-4BAFF3790256}\InprocServer32
ITEM=
EXP=Iexplorr24.dll
NAME=Winshow/Searchv.com hijacker
URL=http://www.doxdesk.com/parasite/Winshow.html
KEY=CLSID\{6CC1C918-AE8B-4373-A5B4-28BA1851E39A}\InprocServer32
ITEM=
EXP=winshow.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{6CC1C91A-AE8B-4373-A5B4-28BA1851E39A}\InprocServer32
ITEM=
EXP=winlink.dll
NAME=SafeguardProtect/Veevo
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453082734
KEY=CLSID\{6CDF3C49-20E6-48d7-811B-9F5DD17F1D90}\InprocServer32
ITEM=
EXP=sfg****.dll
NAME=Comet Cursor
URL=http://www.castlecops.com/tk364-brbho_dll.html
KEY=CLSID\{6D0AC7F7-B628-4581-A8B2-14D97F24AA76}\InprocServer32
ITEM=
EXP=brbho.dll
NAME=BrowserAid/ABCSearch
URL=http://www.doxdesk.com/parasite/CashToolbar.html
KEY=CLSID\{6D55490C-1BD4-4790-BA31-84D261316E28}\InprocServer32
ITEM=
EXP=Highlighthelper.dll
NAME=suspected keyword hijacker
URL=http://computercops.biz/postlite89308-.html
KEY=CLSID\{6D9F42B8-B7E5-4BB9-9A13-CAE53D44196E}\InprocServer32
ITEM=
EXP=searcher.dll
NAME=SafeguardProtect/Veevo
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453082734
KEY=CLSID\{6E1C5E3D-A8E6-4a92-820F-BFCFE45BA158}\InprocServer32
ITEM=
EXP=veev
NAME=SafeguardProtect/Veevo
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453082734
KEY=CLSID\{6E34D984-4054-45E3-8452-0159A2F0D232}\InprocServer32
ITEM=
EXP=Veevo.dll
NAME=FriendGreetings E-Card foistware
URL=http://vil.nai.com/vil/content/v_99760.htm
KEY=CLSID\{7011471D-3F74-498E-88E1-C0491200312D}\InprocServer32
ITEM=
EXP=Otglove.dll
NAME=Xupiter Orbitexplorer
URL=http://www.doxdesk.com/parasite/Xupiter.html
KEY=CLSID\{702AD576-FDDB-4d0f-9811-A43252064684}\InprocServer32
ITEM=
EXP=Toolbar.dll
NAME=TV Media/CleverIEHooker
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453077508
KEY=CLSID\{707E6F76-9FFB-4920-A976-EA101271BC25}\InprocServer32
ITEM=
EXP=Jeired.dll
NAME=HDTbar
URL=http://www.spynet.com/spyware/spyware-HDTBar.aspx
KEY=CLSID\{70B3DA2C-E02D-4ce0-B1F8-48320FD443D2}\InprocServer32
ITEM=
EXP=T2BHO.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{710089CF-87C3-763F-C8F6-5A0DBFD3AEC3}\InprocServer32
ITEM=
EXP=Multiple file names
NAME=321search.com search hijacker
URL=
KEY=CLSID\{7148369a-1105-4e85-83e0-085e784ba374}\InprocServer32
ITEM=
EXP=SearchAssistant.dll
NAME=Blazefind IESearchbar
URL=http://www.kephyr.com/spywarescanner/library/iesearchbar/index.phtml
KEY=CLSID\{71ED4FBA-4024-4bbe-91DC-9704C93F453E}\InprocServer32
ITEM=
EXP=Iesearchbar.dll
NAME=NeoToolbar
URL=http://doxdesk.com/parasite/NeoToolbar.html
KEY=CLSID\{722E8B26-1C44-460F-88BB-50C82B20E30E}\InprocServer32
ITEM=
EXP=msqsb.dll
NAME=LoveTester foistware
URL=http://spamwatch.codefish.net.au/modules.php?op=modload&name=News&file=index&catid=&topic=24
KEY=CLSID\{72557F9F-13AE-44C9-B3D7-5091B599027C}\InprocServer32
ITEM=
EXP=smail11.dll
NAME=ZeroPopupBar
URL=http://www.doxdesk.com/parasite/ZeroPopUp.html
KEY=CLSID\{72A58725-2635-4725-8C53-676DFD1FEB8D}\InprocServer32
ITEM=
EXP=zeropopupbar.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{72AC6865-B1D3-4C32-A27B-4B3BF04DE655}\InprocServer32
ITEM=
EXP=dat
NAME=IGN Keywords
URL=http://www.doxdesk.com/parasite/IGetNet.html
KEY=CLSID\{730F2451-A3FE-4A72-938C-FC8A74F15978}\InprocServer32
ITEM=
EXP=Bho.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{73529697-D46A-4F7D-8A93-01378FCAEDA4}\InprocServer32
ITEM=
EXP=dat
NAME=FlashTrack
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453072523
KEY=CLSID\{7371F073-AC0F-4b80-BB2F-96A488CEFB32}\InprocServer32
ITEM=
EXP=xm320.dll
NAME=SafeSurfing parasite variant
URL=http://research.sunbelt-software.com/threatdisplay.aspx?threatid=14990
KEY=CLSID\{7412C042-43B8-4F63-AEF3-E786DFAD1484}\InprocServer32
ITEM=
EXP=imwire28.dll
NAME=Kugoo IEHelper
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453074922
KEY=CLSID\{748A5D0A-68D3-11D4-A67E-00E098823A80}\InprocServer32
ITEM=
EXP=Iehelper.dll
NAME=i-Lookup/Bmeb
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{753AA023-02D1-447D-8B55-53A91A5ABF18}\InprocServer32
ITEM=
EXP=Bmeb.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{75A46C7E-D7AB-55F3-8DF2-D9A7FFD913E6}\InprocServer32
ITEM=
EXP=Multiple file names
NAME=EZCybersearch bar
URL=http://www.doxdesk.com/parasite/ezCyberSearch.html
KEY=CLSID\{760A9DDE-1433-4A7C-8189-D6735BB5D3DD}\InprocServer32
ITEM=
EXP=EzSearch.dll
NAME=GoGoTools
URL=http://doxdesk.com/parasite/GogoTools.html parasite
KEY=CLSID\{76532682-A5C9-11d8-AE07-00D0591}\InprocServer32
ITEM=
EXP=SearchGogo.dll
NAME=Qcbar/AdultLinks
URL=http://www.doxdesk.com/parasite/AdultLinks.html
KEY=CLSID\{765E6B09-6832-4738-BDBE-25F226BA2AB0}\InprocServer32
ITEM=
EXP=allch.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{77849D67-5672-4B68-93E2-CCEFF1E3949E}\InprocServer32
ITEM=
EXP=dat
NAME=BrowserAid/Startium variant
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{778C2A73-4707-41d1-9269-03FF7DE5FFB8}\InprocServer32
ITEM=
EXP=D3D869D4.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{79369D5C-2903-4b7a-ADE2-D5E0DEE14D24}\InprocServer32
ITEM=
EXP=GoogleMS.dll
NAME=CoolWebSearch parasite variant
URL=http://www.spywareinfo.com/~merijn/cwschronicles.html
KEY=CLSID\{799A370D-5993-4887-9DF7-0A4756A77D00}\InprocServer32
ITEM=
EXP=search.dll
NAME=FastFind adware variant
URL=http://www.trendmicro.com/vinfo/virusencyclo/default5.asp?VName=TROJ_STARTPAG.KF&VSect=T
KEY=CLSID\{79C03BC5-6C55-4B5B-921F-C02B6F1ABD7B}\InprocServer32
ITEM=
EXP=Pribi.dll
NAME=NovaPortal adware
URL=http://www.clickz.com/news/article.php/177951
KEY=CLSID\{79C9FB71-7827-11D3-8DF7-00105A119B7C}\InprocServer32
ITEM=
EXP=NPBH.dll
NAME=Adware.Sa
URL=http://sarc.com/avcenter/venc/data/adware.sa.html
KEY=CLSID\{7B55BB05-0B4D-44fd-81A6-B136188F5DEB}\InprocServer32
ITEM=
EXP=questmod.dll
NAME=FlashEnhancer
URL=http://sarc.com/avcenter/venc/data/adware.flashenhancer.html
KEY=CLSID\{7CD20E91-1F31-41da-8379-479EA31DF969}\InprocServer32
ITEM=
EXP=XML.dll
NAME=Foxxweb Interactive (Softomate) spyware - Foxxweb Interactive (spyware)
URL=
KEY=CLSID\{7D6BEC01-15E2-46F0-8ED3-D715DE09A8F9}\InprocServer32
ITEM=
EXP=
NAME=DailyWinner Prize Bar
URL=http://www.doxdesk.com/parasite/DailyWinner.html
KEY=CLSID\{7DD896A9-7AEB-430F-955B-CD125604FDCB}\InprocServer32
ITEM=
EXP=Veg32.dll
NAME=Backdoor.Berbew.P
URL=http://securityresponse.symantec.com/avcenter/venc/data/backdoor.berbew.p.html
KEY=CLSID\{7EFFAAFF-EA0A-1A3A-CBCD-F13522D53649}\InprocServer32
ITEM=
EXP=dll
NAME=Adpowerzone.com keyword hijacker
URL=
KEY=CLSID\{7FC56022-4EDA-472E-8830-7CA92CCBD025}\InprocServer32
ITEM=
EXP=ServerSide.dll
NAME=CoolWebSearch parasite variant
URL=http://www.spywareinfo.com/~merijn/cwschronicles.html
KEY=CLSID\{7FE49EAE-AA38-4044-9D10-09DAB477051F}\InprocServer32
ITEM=
EXP=popup_bl.dll
NAME=BrowserAid/Rundll16
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{80672997-D58C-4190-9843-C6C61AF8FE97}\InprocServer32
ITEM=
EXP=rundll16.dll
NAME=Hijacker, as yet unidentified
URL=
KEY=CLSID\{8085E374-ACBB-42F9-873F-49EC7E244F97}\InprocServer32
ITEM=
EXP=
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{8109AF33-6949-4833-8881-43DCC232B7B2}\InprocServer32
ITEM=
EXP=dat
NAME=PASSGRAB, a spam relayer, hijacker and email account password stealer
URL=
KEY=CLSID\{81A35F39-4850-474E-92C9-B4CF283207E0}\InprocServer32
ITEM=
EXP=mstask64.dll
NAME=Adware DAE.A
URL=http://www.trendmicro.com/vinfo/grayware/graywareDetails.asp?SNAME=ADW_DAE.A
KEY=CLSID\{81A99149-F047-4090-8AAD-D11FF4EFB734}\InprocServer32
ITEM=
EXP=dae.dll
NAME=Adware.Margoc variant
URL=http://sarc.com/avcenter/venc/data/adware.margoc.html
KEY=CLSID\{81D66134-ADC3-4C6D-B0A9-03D4EE35B849}\InprocServer32
ITEM=
EXP=dll
NAME=New.Net QuickSearch
URL=http://doxdesk.com/parasite/NewDotNet.html
KEY=CLSID\{82315A18-6CFB-44a7-BDFD-90E36537C252}\InprocServer32
ITEM=
EXP=QuickSearchBar
NAME=EliteBar/SearchMiracle adware
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-SearchMiracle.EliteBar.aspx
KEY=CLSID\{825CF5BD-8862-4430-B771-0C15C5CA880F}\InprocServer32
ITEM=
EXP=Elitebar.dll
NAME=Flyswat
URL=http://accs-net.com/smallfish/flyswat.htm
KEY=CLSID\{82B98006-7A56-11D2-A26F-00C04F962769}\InprocServer32
ITEM=
EXP=Flylib.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{82E8FF5B-20DA-4F43-9787-09FA534B7627}\InprocServer32
ITEM=
EXP=dll
NAME=Hijacker,  as yet unidentified
URL=
KEY=CLSID\{832BEBED-C3DA-4534-A2C2-B2FFF220C820}\InprocServer32
ITEM=
EXP=replaceSearch.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{834261E1-DD97-4177-853B-C907E5D5BD6E}\InprocServer32
ITEM=
EXP=dpe.dll
NAME=SafeguardProtect/Veevo
URL=
KEY=CLSID\{83B3E0C1-DEF1-4df5-A3F5-92D10B7A396A}\InprocServer32
ITEM=
EXP=sfg
NAME=ClearStream Accelerator
URL=http://www.spyany.com/program/article_spw_rm_ClearStream_Accelerator.html
KEY=CLSID\{83DC91DB-7896-43E3-B34D-A7D043F16BB1}\InprocServer32
ITEM=
EXP=rdsa.dll
NAME=BlazeFind Websearch
URL=http://www.spywareguide.com/product_show.php?id=724
KEY=CLSID\{83DE62E0-5805-11D8-9B25-00E04C60FAF2}\InprocServer32
ITEM=
EXP=2_0_1browserhelper2.dll
NAME=P0rn related malware
URL=
KEY=CLSID\{8403CB53-12B3-4537-9DEC-4F12F70A883D}\InprocServer32
ITEM=
EXP=thehun.dll
NAME=AlibabaIEToolBar
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-AlibabaIEToolBar.aspx
KEY=CLSID\{850B69E4-90DB-4F45-8621-891BF35A5B53}\InprocServer32
ITEM=
EXP=bar.dll
NAME=eZsearching
URL=http://www.doxdesk.com/parasite/ezSearching.html
KEY=CLSID\{858126B0-3708-4051-AE8E-B48521401CA2}\InprocServer32
ITEM=
EXP=ctsr*.dll
NAME=Medialoads Enhanced/Downloadware
URL=http://www.doxdesk.com/parasite/DownloadWare.html
KEY=CLSID\{85A702BA-EA8F-4B83-AA07-07A5186ACD7E}\InprocServer32
ITEM=
EXP=ME
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{85CBFDE0-B26B-4EE5-BD3C-4DE111DE763E}\InprocServer32
ITEM=
EXP=Winnet.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{870B70D4-F6DA-47AE-9158-D146440A0A4D}\InprocServer32
ITEM=
EXP=dat
NAME=HuntBar/Wintools
URL=http://doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{87766247-311C-43B4-8499-3D5FEC94A183}\InprocServer32
ITEM=
EXP=WToolsB.dll
NAME=BandObjects/eStart
URL=http://www.doxdesk.com/parasite/eStart.html
KEY=CLSID\{8786386E-4B22-11D6-9C60-E5DA06D87378}\InprocServer32
ITEM=
EXP=BandObjs1,0,0,1.dll
NAME=searchingall.com/onedollaremail.com pay-per-click foistware
URL=
KEY=CLSID\{88F0297D-A046-4942-B6B9-03D8939E92D5}\InprocServer32
ITEM=
EXP=DeskwareDownloader.dll
NAME=HuntBar
URL=http://www.doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{8952A998-1E7E-4716-B23D-3DBE03910972}\InprocServer32
ITEM=
EXP=Toolbar.dll
NAME=Xlocator/WinLocator adware
URL=http://www.kephyr.com/spywarescanner/library/xlocator/index.phtml
KEY=CLSID\{89AEAB46-8E8A-4045-9003-5614BFBFE90B}\InprocServer32
ITEM=
EXP=Winlocatorhelper.dll
NAME=NetNucleus/Mirar webband
URL=http://www.kephyr.com/spywarescanner/library/mirartoolbar/index.phtml
KEY=CLSID\{8A0DCBDA-6E20-489C-9041-C1E8A0352E75}\InprocServer32
ITEM=
EXP=NN_Bar.dll
NAME=Mega! Search:  best-search.us hijacker
URL=
KEY=CLSID\{8BC6346B-FFB0-4435-ACE3-FACA6CD77816}\InprocServer32
ITEM=
EXP=MegaHost.dll
NAME=HuntBar/WinTools, adware variant
URL=http://doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{8DA5457F-A8AA-4CCF-A842-70E6FD274094}\InprocServer32
ITEM=
EXP=WToolsT.dll
NAME=ezSearching
URL=http://www.doxdesk.com/parasite/ezSearching.html
KEY=CLSID\{8DB672BD-330F-11D8-8168-00C02623048A}\InprocServer32
ITEM=
EXP=Testadit.dll
NAME=WurldMedia
URL=http://www.doxdesk.com/parasite/WurldMedia.html 
KEY=CLSID\{8E9C4F32-BD3F-4C49-9AF5-3F4C5D32EBD7}\InprocServer32
ITEM=
EXP=mbho.dll
NAME=MoneyTree/DyFuCa
URL=http://www.doxdesk.com/parasite/MoneyTree.html
KEY=CLSID\{8F4E5661-F99E-4B3E-8D85-0EA71C0748E4}\InprocServer32
ITEM=
EXP=Wsem
NAME=i-search.us hijacker
URL=
KEY=CLSID\{8F5A62E2-71F2-72D3-E045-DDF234CAE228}\InprocServer32
ITEM=
EXP=Isearch2.dll
NAME=FizzleWizzle search bar
URL=
KEY=CLSID\{9056A11F-5EA6-4A67-BDE9-8D3C7C453DAC}\InprocServer32
ITEM=
EXP=Iefwbar.dll
NAME=SearchSquire
URL=http://www.doxdesk.com/parasite/SearchSquire.html
KEY=CLSID\{907CA0E5-CE84-11D6-9508-02608CDD2841}\InprocServer32
ITEM=
EXP=SEARCH~2.DLL
NAME=SearchSquire
URL=http://www.doxdesk.com/parasite/SearchSquire.html
KEY=CLSID\{907CA0E5-CE84-11D6-9508-02608CDD2842}\InprocServer32
ITEM=
EXP=SearchSquire2.dll
NAME=SearchSquire
URL=http://doxdesk.com/parasite/SearchSquire.html
KEY=CLSID\{907CA0E5-CE84-11D6-9508-02608CDD2846}\InprocServer32
ITEM=
EXP=SearchUpdate33.dll
NAME=SubSearch
URL=http://www.doxdesk.com/parasite/SubSearch.html
KEY=CLSID\{90DA654C-083C-11D6-8A9D-0050BA8452C0}\InprocServer32
ITEM=
EXP=sbsrch_v2.dll
NAME=InetSpeak/Iexplorr
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{90E34F98-E3E6-4CD7-A592-E964FED8AF78}\InprocServer32
ITEM=
EXP=iexplorr26.dll
NAME=IEPlugin
URL=http://www.doxdesk.com/parasite/IEPlugin.html
KEY=CLSID\{914AFB33-550B-4BD0-B4EF-8DA185504836}\InprocServer32
ITEM=
EXP=Winobject.dll
NAME=Trojan.Goldun.B
URL=http://securityresponse.symantec.com/avcenter/venc/data/trojan.goldun.b.html
KEY=CLSID\{92617934-9abc-def0-0fed-fad48c654321}\InprocServer32
ITEM=
EXP=
NAME=ActualNames SearchPike
URL=http://www.doxdesk.com/parasite/ActualNames.html
KEY=CLSID\{92C7D65C-52F3-4545-8A35-213D730DB1ED}\InprocServer32
ITEM=
EXP=Spredirect.dll
NAME=AdBlaster
URL=http://www.xblock.com/product_show.php?id=787
KEY=CLSID\{941CA48C-3984-4E7D-AAF8-8755ED76EB50}\InprocServer32
ITEM=
EXP=dll
NAME=InetSpeak/Iexplorr
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{94326E3F-F51F-4863-A832-4ACD0D7D4BC3}\InprocServer32
ITEM=
EXP=iexplorr27.dll
NAME=ClearSearch
URL=http://doxdesk.com/parasite/ClearSearch.html
KEY=CLSID\{947E6D5A-4B9F-4CF4-91B3-562CA8D03313}\InprocServer32
ITEM=
EXP=IE_ClrSch.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{94927A13-4AAA-476A-989D-392456427688}\InprocServer32
ITEM=
EXP=urlcli
NAME=FlashTrack parasite
URL=http://doxdesk.com/parasite/FlashTrack.html
KEY=CLSID\{95795B67-BBAB-47d0-8A9F-069E8242C0E5}\InprocServer32
ITEM=
EXP=Fen.dll
NAME=Superlogy.com hijacker
URL=
KEY=CLSID\{95E02C52-05FC-425D-8378-9DA70F9CD763}\InprocServer32
ITEM=
EXP=Aadl.dll
NAME=Top-banners.com adware
URL=
KEY=CLSID\{968BC8A3-7660-4B12-B2BF-3334775835E1}\InprocServer32
ITEM=
EXP=KGhost.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{96BE1D9A-9E54-4344-A27A-37C088D64FB4}\InprocServer32
ITEM=
EXP=dnsrep
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{96BE1D9A-9E54-4344-A27A-37C088D64FB4}\InprocServer32
ITEM=
EXP=mseffm.dll
NAME=Comet Cursor
URL=http://www.doxdesk.com/parasite/CometCursor.html
KEY=CLSID\{96DA5BEE-4ACC-476C-B3EC-54C6730C4293}\InprocServer32
ITEM=
EXP=brbho.dll
NAME=Dynamic Desktop Media adware variant
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453079029
KEY=CLSID\{9819C369-5F62-4D37-9A42-44043A742C1E}\InprocServer32
ITEM=
EXP=redirect.dll
NAME=Adware.Admess
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.admess.html
KEY=CLSID\{9896231A-C487-43A5-8369-6EC9B0A96CC0}\InprocServer32
ITEM=
EXP=WStart.dll
NAME=WurldMedia
URL=http://www.doxdesk.com/parasite/WurldMedia.html
KEY=CLSID\{98D7B53E-B1D2-4755-B0A4-703E18FF91E8}\InprocServer32
ITEM=
EXP=M030106SHOP.DLL
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{98DBBF16-CA43-4c33-BE80-99E6694468A4}\InprocServer32
ITEM=
EXP=msole.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{99D764FC-CDD7-00B8-618D-0880E43E5DFC}\InprocServer32
ITEM=
EXP=dll
NAME=from imu.com.cn
URL=
KEY=CLSID\{9A0527C1-4D5F-4e45-9D28-6257F75EDDB1}\InprocServer32
ITEM=
EXP=imuiepls.dll
NAME=NetNucleus/Mirar webband
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453078818
KEY=CLSID\{9A9C9B69-F908-4AAB-8D0C-10EA8997F37E}\InprocServer32
ITEM=
EXP=WinNB
NAME=Matrix Technology Network 123Mania
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453094812
KEY=CLSID\{9C5B2F29-1F46-4639-A6B4-828942301D3E}\InprocServer32
ITEM=
EXP=SIPSPI32.DLL
NAME=Adware.WinFavorites
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.winfavorites.html
KEY=CLSID\{9C691A33-7DDA-4C2F-BE4C-C176083F35CF}\InprocServer32
ITEM=
EXP=bridge.dll
NAME=RedV Protector Suite
URL=http://services.bee.net/redv/protectorsuite/
KEY=CLSID\{9C777253-3E17-42d6-897A-11B8617A8F7C}\InprocServer32
ITEM=
EXP=IELib.dll
NAME=MSN SmartTags
URL=http://www.zdnet.com/anchordesk/stories/story/0,10738,2771967,00.html
KEY=CLSID\{9DD4258A-7138-49C4-8D34-587879A5C7A4}\InprocServer32
ITEM=
EXP=Msnbho.dll
NAME=FastFind adware variant
URL=http://www.trendmicro.com/vinfo/virusencyclo/default5.asp?VName=TROJ_STARTPAG.KF&VSect=T
KEY=CLSID\{9E992732-295F-4987-8BE3-16FAC1639198}\InprocServer32
ITEM=
EXP=IEService.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{9EAC0102-5E61-2312-BC2D-414456544F4E}\InprocServer32
ITEM=
EXP=ADV.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{9EAC0102-5E61-2312-BC2D-444C4C4F5552}\InprocServer32
ITEM=
EXP=DLL.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{9EAC0102-5E61-2312-BC2D-4D54434D5443}\InprocServer32
ITEM=
EXP=mtc.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{9EAC0102-5E61-2312-BC2D-4E4153202020}\InprocServer32
ITEM=
EXP=NAS.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{9EAC0102-5E61-2312-BC2D-544243544243}\InprocServer32
ITEM=
EXP=TBC.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{9EAC0102-5E61-2312-BC2D-76746C56544C}\InprocServer32
ITEM=
EXP=vtlbar1.dll
NAME=Windows Search Bar hijacker
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453083030
KEY=CLSID\{9FB534E3-67CB-4307-AE0A-9E8B5581BE2C}\InprocServer32
ITEM=
EXP=WinSB.dll
NAME=iLookup parasite variant
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{9FF528A9-7314-4658-B497-3D1D4597B300}\InprocServer32
ITEM=
EXP=wingss32.dll
NAME=IncrediFind variant
URL=http://www.doxdesk.com/parasite/KeenValue.html
KEY=CLSID\{A045DC85-FC44-45be-8A50-E4F9C62C9A84}\InprocServer32
ITEM=
EXP=PerfectNavBHO.dll
NAME=SearchFu/123Search
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453075308
KEY=CLSID\{A096A159-4E58-45A9-8EE6-B11466851181}\InprocServer32
ITEM=
EXP=msietk1020.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{A097840A-61F8-4B89-8693-F68F641CC838}\InprocServer32
ITEM=
EXP=urlcli
NAME=Searchex
URL=http://www.doxdesk.com/parasite/Searchex.html
KEY=CLSID\{A116A5C1-AD77-446C-992A-F56200B112DB}\InprocServer32
ITEM=
EXP=Homepage.dll
NAME=SafeguardProtect/Veevo
URL=
KEY=CLSID\{A23AB93D-6CFF-442c-BB8A-41F6145F47E7}\InprocServer32
ITEM=
EXP=PDF
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{A2833482-B023-4C65-B09D-EE47A4E8CC56}\InprocServer32
ITEM=
EXP=botnet1.dll
NAME= BonziBuddy
URL=http://accs-net.com/smallfish/bonzi.htm 
KEY=CLSID\{A28C2A31-3AB0-4118-922F-F6B3184F5495}\InprocServer32
ITEM=
EXP=WebCompass.dll
NAME=Adware.IESP.mht/CasinoPalazzo foistware
URL=http://www.bluestack.org/Iesp.Mht?show_comments=1
KEY=CLSID\{A3DFDA85-1D92-4E28-8C0C-522574ACDC8A}\InprocServer32
ITEM=
EXP=msacrohlp.dll
NAME=IS Technologies SideFind
URL=http://www.sophos.com/virusinfo/analyses/trojistbarm.html
KEY=CLSID\{A3FDD654-A057-4971-9844-4ED8E67DBBB8}\InprocServer32
ITEM=
EXP=sfbho.dll
NAME=SafeguardProtect/Veevo
URL=http://www.castlecops.com/tk1208-Popup_Blocker_Pro.html
KEY=CLSID\{A44B961C-8C36-470f-8555-EDA0EFC1E710}\InprocServer32
ITEM=
EXP=popupblocker.dll
NAME=Troj/Bdoor-CLS
URL=http://www.sophos.com/virusinfo/analyses/trojbdoorcls.html
KEY=CLSID\{A452DA63-4286-48EB-A838-3BA85C3049F5}\InprocServer32
ITEM=
EXP=Acrobat.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{A5366673-E8CA-11D3-9CD9-0090271D075B}\InprocServer32
ITEM=
EXP=msacmx.dll
NAME=Httper
URL=http://www.doxdesk.com/parasite/Httper.html
KEY=CLSID\{A5483501-070C-41DD-AF44-9BD8864B3015}\InprocServer32
ITEM=
EXP=httper.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{A55581DC-2CDB-4089-8878-71A080B22342}\InprocServer32
ITEM=
EXP=Autosearch.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{A5E0B170-04FA-11d1-B7DA-00A0C90348D6}\InprocServer32
ITEM=
EXP=msdocvw.dll
NAME=Huntbar
URL=http://www.doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{A6250FB8-2206-499E-A7AA-E1EC437E71C0}\InprocServer32
ITEM=
EXP=Msielink.dll
NAME=Commonname toolbar
URL=http://www.doxdesk.com/parasite/CommonName.html
KEY=CLSID\{A6475E6B-3C2E-4B1F-82FD-8F1C0B1D8AD0}\InprocServer32
ITEM=
EXP=BabeIE.dll
NAME=Trojan.Magise
URL=http://securityresponse.symantec.com/avcenter/venc/data/trojan.magise.html
KEY=CLSID\{A6790AA5-C6C7-4BCF-A46D-0FDAC4EA90EB}\InprocServer32
ITEM=
EXP=msearch.dll
NAME=Adware.IEPageHelper
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453083026
KEY=CLSID\{A6F42CAD-2559-48DF-AF30-89E480AF5DFA}\InprocServer32
ITEM=
EXP=Bho.dll
NAME=InetSpeak/Iexplorr
URL=http://www.symantec.com/security_response/print_writeup.jsp?docid=2005-060222-0943-99
KEY=CLSID\{A76066C9-941B-4209-9D96-0AC80501100D}\InprocServer32
ITEM=
EXP=iexplorr11.dll
NAME=Adtomi adware variant
URL=http://safersite.net/pestinfo%5Ca%5Cadtomi.asp
KEY=CLSID\{A78860C8-EE1A-46DF-A97F-E3E6D433E80B}\InprocServer32
ITEM=
EXP=dll
NAME=Clickspring/PurityScan
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453077027
KEY=CLSID\{A78CC2FF-6E4E-4556-B27C-D7C3A70D7A50}\InprocServer32
ITEM=
EXP=NDrv.dll
NAME=BookedSpace
URL=http://www.castlecops.com/tk480-CExtension_Object.html
KEY=CLSID\{A85C4A1B-BD36-44E5-A70F-8EC347D9B24F}\InprocServer32
ITEM=
EXP=bs3.dll
NAME=HighTraffic
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453072526
KEY=CLSID\{A8B9F08F-2FC4-4ADE-9049-CFBA586971BA}\InprocServer32
ITEM=
EXP=Bho2.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{A903BF95-883E-4E70-AEC8-6C27CDC0A6B2}\InprocServer32
ITEM=
EXP=dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{A9A674BF-771F-42E5-A440-D20DDA85A862}\InprocServer32
ITEM=
EXP=dll
NAME=CheckUrl
URL=http://www.pestpatrol.com/spywarecenter/pest.aspx?id=453078193
KEY=CLSID\{A9EEF0D7-5695-45BA-8943-ED3B95A50BD2}\InprocServer32
ITEM=
EXP=CheckUrl.dll
NAME=ClearStream Accelerator
URL=http://www.spyany.com/program/article_spw_rm_ClearStream_Accelerator.html
KEY=CLSID\{AC109D01-32D6-4EB5-8300-D3C5EBAC7C83}\InprocServer32
ITEM=
EXP=X2ff.dll
NAME=Adware.Slagent
URL=http://securityresponse.symantec.com/avcenter/venc/data/trojan.simcss.b.html
KEY=CLSID\{ACB3E0B7-7D0C-40B7-99B3-3EEACDF86BFB}\InprocServer32
ITEM=
EXP=4b_1,0,1,1_mslagent.dll
NAME=eXact Advertising
URL=http://www.doxdesk.com/parasite/BargainBuddy.html
KEY=CLSID\{AEECBFDA-12FA-4881-BDCE-8C3E1CE4B344}\InprocServer32
ITEM=
EXP=nvms.dll
NAME=ezSearching
URL=http://www.doxdesk.com/parasite/ezSearching.html
KEY=CLSID\{AEFCDEC8-EB7D-429F-BC73-4F30D07BFE41}\InprocServer32
ITEM=
EXP=ctadl
NAME=Hotbar
URL=http://www.doxdesk.com/parasite/HotBar.html
KEY=CLSID\{B195B3B3-8A05-11D3-97A4-0004ACA6948E}\InprocServer32
ITEM=
EXP=Hbhostie.dll
NAME=t2t2.com toolbar by Chengwei Ventures LLC
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453097227
KEY=CLSID\{B1D147E7-873E-4909-8127-695D9BB78728}\InprocServer32
ITEM=
EXP=barhelp.dll
NAME=Kugoo IEHelper
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453074922
KEY=CLSID\{B3ECCAC9-C7FA-462C-894B-8E9930A70E14}\InprocServer32
ITEM=
EXP=IEHelper
NAME=Searchex
URL=http://www.doxdesk.com/parasite/Searchex.html
KEY=CLSID\{B405EE45-1AA2-410D-A6CF-1A74371DCD62}\InprocServer32
ITEM=
EXP=Hotlink.dll
NAME=iChoose browser enhancement
URL=http://www.luckysoftware.dk/ichoose.php
KEY=CLSID\{B40A6610-1D16-11D3-80B2-005004994DA2}\InprocServer32
ITEM=
EXP=Bpieclient.dll
NAME=Adware.Adtomi
URL=http://sarc.com/avcenter/venc/data/adware.adtomi.html
KEY=CLSID\{B549456D-F5D0-4641-BCED-8648A0C13D83}\InprocServer32
ITEM=
EXP=BrowserHelper.dll
NAME=BaiDu toolbar
URL=
KEY=CLSID\{B580CF65-E151-49C3-B73F-70B13FCA8E86}\InprocServer32
ITEM=
EXP=BaiDuBar.dll
NAME=EZSearching
URL=http://www.doxdesk.com/parasite/ezSearching.html
KEY=CLSID\{B6598677-4B54-42A9-BA67-8B64E3FCD92D}\InprocServer32
ITEM=
EXP=psic
NAME=Troj/StartPa-DW hijacker variant
URL=http://www.sophos.com/virusinfo/analyses/trojstartpadw.html
KEY=CLSID\{B72F75B8-93F3-429D-B13E-660B206D897A}\InprocServer32
ITEM=
EXP=beem.dll
NAME=SafeguardProtect/Veevo
URL=http://www.castlecops.com/tk499-Sgpopupblocker_dll.html
KEY=CLSID\{B824E7B0-E8E3-4D75-895E-2C309EA4CC5D}\InprocServer32
ITEM=
EXP=Sgpopupblocker.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{B847676D-72AC-4393-BFFF-43A1EB979352}\InprocServer32
ITEM=
EXP=wcadw.dll
NAME=MediaUpdate
URL=http://www.doxdesk.com/parasite/MediaUpdate.html
KEY=CLSID\{B8C0220D-763D-49A4-95F4-61DFDEC66EE6}\InprocServer32
ITEM=
EXP=MEDUP012.DLL
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{B957F25D-F812-44c4-A23C-249CCFE0AAE0}\InprocServer32
ITEM=
EXP=msnet.dll
NAME=Netster Smart Browse Toolbar
URL=http://at.netster.com/Index.asp?Site=YXQubmV0c3Rlci5jb20%3D
KEY=CLSID\{B98F79F4-3619-49FB-A7E7-B737E58C5727}\InprocServer32
ITEM=
EXP=netster.dll
NAME=CashSaver spyware
URL=http://auction.ahnlab.com/badcode_info_view.asp?list=/badcode_info_list.asp&seq=1551
KEY=CLSID\{B9ADBF45-B136-4FC5-8582-48C2A22600CE}\InprocServer32
ITEM=
EXP=cashsaverbho.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{B9D90B27-AD4A-413a-88CB-3E6DDC10DC2D}\InprocServer32
ITEM=
EXP=MSOPT.DLL
NAME=GoHip/Browserenh
URL=http://www.gohip.com/
KEY=CLSID\{BA3D9F56-5EC1-497D-881A-93A28F58D9AD}\InprocServer32
ITEM=
EXP=IE.dll
NAME=Icoo Loader
URL=http://www.by-users.co.uk/forums/?board=help&action=display&num=1085918311
KEY=CLSID\{BA7270AE-5636-4618-BAF3-F86ADA39F036}\InprocServer32
ITEM=
EXP=icoourl.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{ba77911b-a393-4a2e-b5b5-5b8ed17d7b43}\InprocServer32
ITEM=
EXP=disable1.dll
NAME=Divago Surfairy
URL=http://www.doxdesk.com/parasite/Surfairy.html
KEY=CLSID\{BB9AAAF3-4F8D-48B5-A565-FF3E58433DC2}\InprocServer32
ITEM=
EXP=SurfairyHlp.dll
NAME=InetSpeak/Iexplorr
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{BC0D2038-2DE5-4A6F-92BC-B18A3E0DE32A}\InprocServer32
ITEM=
EXP=iexplorr11.dll
NAME=BDPLugin
URL=http://www.spyany.com/program/article_adw_rm_BDHelper.html
KEY=CLSID\{BC207F7D-3E63-4ACA-99B5-FB5F8428200C}\InprocServer32
ITEM=
EXP=Bdsrhook.dll
NAME=Adware.HungryHands
URL=http://sarc.com/avcenter/venc/data/pf/adware.hungryhands.html
KEY=CLSID\{BCF96FB4-5F1B-497B-AECC-910304A55011}\InprocServer32
ITEM=
EXP=hh.dll
NAME=FastFind.org SubSearch
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453074896
KEY=CLSID\{BD0BA5CD-7C8E-47ED-935E-1ABBAC9B29E0}\InprocServer32
ITEM=
EXP=88313.dll
NAME=IETray
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453076077
KEY=CLSID\{BD51AEC6-7991-4A60-94D6-D5FEBB655D10}\InprocServer32
ITEM=
EXP=IEMsg.dll
NAME=AdRoar
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453077256
KEY=CLSID\{BDF6CE3D-F5C5-4462-9814-3C8EAC330CA8}\InprocServer32
ITEM=
EXP=AdRoar.dll
NAME=Hijacker, unidentified
URL=http://research.sunbelt-software.com/threatdisplay.aspx?threatid=13043
KEY=CLSID\{BEB133E5-FD72-43b7-8AFF-681831CC72D9}\InprocServer32
ITEM=
EXP=wiesasp2.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{BF755B85-EA69-4F58-9A59-D85F384A15FF}\InprocServer32
ITEM=
EXP=dat
NAME=Unknown Adware
URL=http://www.superadblocker.com/spywaredisplay.html?id=1281
KEY=CLSID\{C003C49F-53E4-4A72-B7D6-0B2B9997392F}\InprocServer32
ITEM=
EXP=webdir.dll
NAME=Spyware.DigitalNames
URL=http://securityresponse.symantec.com/avcenter/venc/data/spyware.digitalnames.html
KEY=CLSID\{C18517DA-CA70-46CE-86F4-882F6B62E975}\InprocServer32
ITEM=
EXP=bms.dll
NAME=NavExcel browser helper
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453074928
KEY=CLSID\{C1E58A84-95B3-4630-B8C2-D06B77B7A0FC}\InprocServer32
ITEM=
EXP=Nhelper.dll
NAME=Gigasearch.biz hijacker
URL=http://www.castlecops.com/tk1628-Giga_Search.html
KEY=CLSID\{C1EA1782-8E6E-4ea4-9800-B68DE41F1A26}\InprocServer32
ITEM=
EXP=gigasoft.dll
NAME=iWon Toolbar
URL=http://www.castlecops.com/tk526-Iwonbar_dll.html
KEY=CLSID\{C298fb42-e3e2-11d3-adcd-0050dac24e8f}\InprocServer32
ITEM=
EXP=Iwonbar.dll
NAME=Wishbone Toolbar
URL=http://www.wishbonemedia.com/products.html
KEY=CLSID\{C331BD6E-06AB-41A0-B95F-D7CA379ACEAA}\InprocServer32
ITEM=
EXP=WBM.DLL
NAME=Vividence Connector
URL=http://www.vividence.com/public/products/vividence+xms+enterprise/vividence+xms+enterprise/connector.htm
KEY=CLSID\{C3BCC488-1AE7-11D4-AB82-0010A4EC2338}\InprocServer32
ITEM=
EXP=hoproxy.dll
NAME=Troj/Bamer-B
URL=http://www.sophos.com/virusinfo/analyses/trojbamerb.html
KEY=CLSID\{C41A1C0E-EA6C-11D4-B1B8-444553540000}\InprocServer32
ITEM=
EXP=rundll32.dll
NAME=http://www.doxdesk.com/parasite/InetSpeak.html
URL=eBoom Search Bar,  InetSpeak varian
KEY=CLSID\{C4D99500-4C77-11D4-93B7-0040950570BA}\InprocServer32
ITEM=
EXP=boombar.dll
NAME=SideSearch variant
URL=http://doxdesk.com/parasite/Sidesearch.html
KEY=CLSID\{C5183ABC-EB6E-4E05-B8C9-500A16B6CF94}\InprocServer32
ITEM=
EXP=sep.dll
NAME=MyBHOSpy (suspected spyware)
URL=
KEY=CLSID\{C52CBAEC-D969-4635-9F50-426CC15CE463}\InprocServer32
ITEM=
EXP=413
NAME=BlazeFind Websearch
URL=http://www.spywareguide.com/product_show.php?id=724
KEY=CLSID\{C5941EE5-6DFA-11D8-86B0-0002441A9695}\InprocServer32
ITEM=
EXP=3_0_1browserhelper3.dll
NAME=Coulomb dialer related parasite
URL=
KEY=CLSID\{C68AE9C0-0909-4DDC-B661-C1AFB9F5AE50}\InprocServer32
ITEM=
EXP=saristar.dll
NAME=OnWebMedia adware variant
URL=
KEY=CLSID\{C68AE9C0-0909-4DDC-B661-C1AFB9F5AE51}\InprocServer32
ITEM=
EXP=AdEnh.dll
NAME=IE Redirector.  browser hijacker
URL=
KEY=CLSID\{C68AE9C0-0909-4DDC-B661-C1AFB9F5AE53}\InprocServer32
ITEM=
EXP=Ieredir.dll
NAME=OnWebMedia adware variant
URL=
KEY=CLSID\{C68AE9C0-0909-4DDC-B661-C1AFB9F5AE56}\InprocServer32
ITEM=
EXP=AdEnh.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{C69FA570-7FDE-4C49-A7BC-CB1CF24BE66B}\InprocServer32
ITEM=
EXP=dat
NAME=EasyBar/Toolbarcash
URL=http://www.castlecops.com/tk539-BHO_Class.html
KEY=CLSID\{C77E900A-FF55-400E-9BAA-E042C8212898}\InprocServer32
ITEM=
EXP=ToolbarStarter.dll
NAME=System61 hijacker
URL=
KEY=CLSID\{C7967580-5F17-11D4-AAC2-0000B4936E0C}\InprocServer32
ITEM=
EXP=System61.dll
NAME=NetPal/PrizePopper
URL=http://www.doxdesk.com/parasite/NetPal.html
KEY=CLSID\{C7ADE150-743D-11D4-8141-00E029626F6A}\InprocServer32
ITEM=
EXP=KER7120.DLL
NAME=i-Lookup/Chgrgs
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{C82B55F0-60E0-478C-BC55-E4E22F11301D}\InprocServer32
ITEM=
EXP=Chgrgs.dll
NAME=Webhancer
URL=http://www.cexx.org/webhancer.htm 
KEY=CLSID\{C900B400-CDFE-11D3-976A-00E02913A9E0}\InprocServer32
ITEM=
EXP=Whiehlpr.dll
NAME=SurfSideKick adware
URL=http://www.spynet.com/spyware/spyware-SurfSideKick.aspx
KEY=CLSID\{CA0E28FA-1AFD-4C21-A8DC-70EB5BE2F076}\InprocServer32
ITEM=
EXP=SskBho.dll
NAME=CnsMin variant
URL=http://www.doxdesk.com/parasite/CnsMin.html
KEY=CLSID\{CA92B524-BC8A-4610-BD2C-6BD3E28155D0}\InprocServer32
ITEM=
EXP=Bdhelper.dll
NAME=Adware.Begin2Search
URL=http://sarc.com/avcenter/venc/data/adware.begin2search.html
KEY=CLSID\{CB5B2BC6-F957-4D8A-BE67-83F3EC58BA01}\InprocServer32
ITEM=
EXP=dsktrf.dll
NAME=I-Lookup
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{CBA523B2-1906-4D14-95A2-CD8E233701C7}\InprocServer32
ITEM=
EXP=waeb.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{CBEFB350-ED5B-4115-B846-C1041676B377}\InprocServer32
ITEM=
EXP=CustomIE.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{CBEFB350-ED5B-4115-B846-C1041676B388}\InprocServer32
ITEM=
EXP=CustIE32.dll
NAME=esyndicate.com/seeq.com toolbar
URL=
KEY=CLSID\{CC378B83-9577-44D0-B4F8-0DD965E176FC}\InprocServer32
ITEM=
EXP=esyn.dll
NAME=ClientMan
URL=http://www.doxdesk.com/parasite/ClientMan.html
KEY=CLSID\{CC916B4B-BE44-4026-A19D-8C74BBD23361}\InprocServer32
ITEM=
EXP=Gstyle~1.dll
NAME=CSApp
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453079138
KEY=CLSID\{CD209A08-98B5-4669-AF9F-447AC5253356}\InprocServer32
ITEM=
EXP=CSapp.dll
NAME=SearchCentrix adware variant
URL=http://www.kephyr.com/spywarescanner/library/searchcentrix.barbho/index.phtml
KEY=CLSID\{CD2A865B-6C0F-44F9-BAA1-7CDB31E04BC8}\InprocServer32
ITEM=
EXP=BarBHO.dll
NAME=GoZilla
URL=http://www.oit.duke.edu/ats/support/spyware/gozilla.html
KEY=CLSID\{CD4C3CF0-4B15-11D1-ABED-709549C10000}\InprocServer32
ITEM=
EXP=Goiehlp.dll
NAME=WurldMedia
URL=http://www.doxdesk.com/parasite/WurldMedia.html
KEY=CLSID\{CDBCFEAE-10BA-482C-9F6E-FC67207082D8}\InprocServer32
ITEM=
EXP=mdefshop.dll
NAME=eXact Advertising
URL=http://www.doxdesk.com/parasite/BargainBuddy.html
KEY=CLSID\{CE188402-6EE7-4022-8868-AB25173A3E14}\InprocServer32
ITEM=
EXP=mscb.dll
NAME=Bargain Buddy
URL=http://www.doxdesk.com/parasite/BargainBuddy.html
KEY=CLSID\{CE31A1F7-3D90-4874-8FBE-A5D97F8BC8F1}\InprocServer32
ITEM=
EXP=Apuc.dll
NAME=URLBlaze
URL=http://www.urlblaze.com
KEY=CLSID\{CE7C3CF0-4B15-11D1-ABED-709549C10000}\InprocServer32
ITEM=
EXP=Ubmon.dll
NAME=ShopNavSearch/Srng
URL=http://www.doxdesk.com/parasite/Srng.html
KEY=CLSID\{CE7C3CF0-4B15-11D1-ABED-709549C10000}\InprocServer32
ITEM=
EXP=Iehelper.dll
NAME=Win32.StartPage.np hijacker
URL=
KEY=CLSID\{CE7C3CF0-4B15-11D1-ABED-709549C10000}\InprocServer32
ITEM=
EXP=StopzillaBH0.dll
NAME=IeMonit
URL=http://www.doxdesk.com/parasite/IEMonit.html
KEY=CLSID\{CE7C3CF0-4B15-11D1-ABED-709549C10001}\InprocServer32
ITEM=
EXP=iemonit.dll
NAME=Trojan FAVADD.C
URL=http://uk.trendmicro-europe.com/enterprise/security_info/ve_detail.php?Vname=TROJ_FAVADD.C
KEY=CLSID\{CE7C3CF0-4B15-11D1-ABED-709549C10020}\InprocServer32
ITEM=
EXP=random named
NAME=Ride MG adware
URL=http://www.ridemg.com/about.html
KEY=CLSID\{CE7EF827-47CC-48EB-B570-C367F1E1277E}\InprocServer32
ITEM=
EXP=x1ff.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-716D61788264}\InprocServer32
ITEM=
EXP=max8264.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-716D74632608}\InprocServer32
ITEM=
EXP=mtc2608.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717177650486}\InprocServer32
ITEM=
EXP=QWE0486.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717177654820}\InprocServer32
ITEM=
EXP=qwe4820.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717177657972}\InprocServer32
ITEM=
EXP=qwe7972.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717177658264}\InprocServer32
ITEM=
EXP=max8264.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-7173706D1316}\InprocServer32
ITEM=
EXP=spm1316.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-7173706D4820}\InprocServer32
ITEM=
EXP=spm4820.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-71766C641306}\InprocServer32
ITEM=
EXP=vld1306.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717765721306}\InprocServer32
ITEM=
EXP=wer1306.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717765721316}\InprocServer32
ITEM=
EXP=wer1316.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717765724820}\InprocServer32
ITEM=
EXP=wer4820.dll
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717965725750}\InprocServer32
ITEM=
EXP=yer5750
NAME=Tubby/MakeMeSearch/Spyware.Arau parasite
URL=http://www.doxdesk.com/parasite/Tubby.html
KEY=CLSID\{CF021F40-3E14-23A5-CBA2-717965726032}\InprocServer32
ITEM=
EXP=yer6032.dll
NAME=WurldMedia
URL=http://www.doxdesk.com/parasite/WurldMedia.html
KEY=CLSID\{D14641FA-445B-448E-9994-209f7AF15641}\InprocServer32
ITEM=
EXP=mbho.dll
NAME=Comet Cursor
URL=http://www.doxdesk.com/parasite/CometCursor.html
KEY=CLSID\{D14D6793-9B65-11D3-80B6-00500487BDBA}\InprocServer32
ITEM=
EXP=Csbho.dll
NAME=CnsMin
URL=http://www.doxdesk.com/parasite/CnsMin.html
KEY=CLSID\{D157330A-9EF3-49F8-9A67-4141AC41ADD4}\InprocServer32
ITEM=
EXP=CnsHook.dll
NAME=Alexa Toolbar
URL=http://pages.alexa.com/prod_serv/webmasters.html?p=Dest_W_t_40_L1
KEY=CLSID\{D1F6ABEF-B889-11D2-8E3C-DCCA155F9A71}\InprocServer32
ITEM=
EXP=Alexaie.dll
NAME=ClearStream Accelerator
URL=http://www.spyany.com/program/article_spw_rm_ClearStream_Accelerator.html
KEY=CLSID\{D319662B-D5BF-4538-ADF3-8D3E36362608}\InprocServer32
ITEM=
EXP=x0ff.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{D34F08C5-4F18-477c-86CB-1A9BEECFE37B}\InprocServer32
ITEM=
EXP=dll
NAME=BrowserPal Toolbar
URL=http://www.doxdesk.com/parasite/BrowserAid.html
KEY=CLSID\{D34F641F-5210-4EB0-8ED5-9179F47E15B7}\InprocServer32
ITEM=
EXP=blckbho.dll
NAME=EZCybersearch/Surebar
URL=http://www.doxdesk.com/parasite/ezCyberSearch.html
KEY=CLSID\{D3F01312-8A3D-4D41-A4FA-FB61D295CB6B}\InprocServer32
ITEM=
EXP=Surebar.dll
NAME=Lop.com
URL=http://www.doxdesk.com/parasite/lop.html
KEY=CLSID\{D44B5436-B3E4-4595-B0E9-106690E70A58}\InprocServer32
ITEM=
EXP=plg_ie0.dll
NAME=Xupiter Orbitexplorer
URL=http://www.doxdesk.com/parasite/Xupiter.html
KEY=CLSID\{D48F2E28-68E2-4920-9848-D6E6C7AB3EB7}\InprocServer32
ITEM=
EXP=Redirector.dll
NAME=SafeguardProtect/Veevo
URL=http://www.castlecops.com/tk965-Core_Library.html
KEY=CLSID\{D4D505DF-D582-400c-91B6-84921012AFE3}\InprocServer32
ITEM=
EXP=pdf
NAME=Adware.Margoc
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.margoc.html
KEY=CLSID\{D537A3D0-8C07-4D62-953F-162207F5090D}\InprocServer32
ITEM=
EXP=regsvrac32.dll
NAME=Whazit
URL=http://www.doxdesk.com/parasite/Whazit.html
KEY=CLSID\{D5B72AED-E54A-11D6-B1B2-444553540000}\InprocServer32
ITEM=
EXP=Bho.dll
NAME=SmartPops
URL=http://www.kephyr.com/spywarescanner/library/smartpops/index.phtml
KEY=CLSID\{D5C778F1-CF13-4E70-ADF0-45A953E7CB8B}\InprocServer32
ITEM=
EXP=Ne.dll
NAME=power-linking-profits.com toolbar
URL=
KEY=CLSID\{D6223CBC-A263-4CB1-B35E-1AE40FEF3B3B}\InprocServer32
ITEM=
EXP=ietoolbar.dll
NAME=InetSpeak
URL=http://www.doxdesk.com/parasite/InetSpeak.html
KEY=CLSID\{D6862A22-1DD6-11D3-BB7C-444553540000}\InprocServer32
ITEM=
EXP=Bho.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{D6964FD8-3AF1-4A2A-ABB7-3D0C62924FD6}\InprocServer32
ITEM=
EXP=dat
NAME=HuntBar
URL=http://www.doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{D6DFF6D8-B94B-4720-B730-1C38C7065C3B}\InprocServer32
ITEM=
EXP=Btlink.dll
NAME=HuntBar
URL=http://www.doxdesk.com/parasite/HuntBar.html
KEY=CLSID\{D6E66235-7AA6-44ED-A06C-6F2033B1D993}\InprocServer32
ITEM=
EXP=Msiein.dll
NAME=Qcbar/AdultLinks
URL=http://www.doxdesk.com/parasite/AdultLinks.html
KEY=CLSID\{D6FC35D1-04AB-4D40-94CF-2E5AE4D0F8D2}\InprocServer32
ITEM=
EXP=llch.dll
NAME=SideStep
URL=http://www.doxdesk.com/parasite/SideStep.html
KEY=CLSID\{D714A94F-123A-45CC-8F03-040BCAF82AD6}\InprocServer32
ITEM=
EXP=SbCIe028.dll
NAME=0CAT YellowPages
URL=http://www.spynet.com/spyware/spyware-0cat-yellowpages.aspx
KEY=CLSID\{D797AD6C-6447-4DB4-91D0-090344408E72}\InprocServer32
ITEM=
EXP=STIEbar.dll
NAME=Trojan.Magise
URL=http://securityresponse.symantec.com/avcenter/venc/data/trojan.magise.html
KEY=CLSID\{D7BF3304-138B-4DD5-86EE-491BB6A2286C}\InprocServer32
ITEM=
EXP=msearch.dll
NAME=Whazit
URL=http://www.doxdesk.com/parasite/Whazit.html
KEY=CLSID\{D7D7004C-A763-4F8C-B0D4-55A7E017E69D}\InprocServer32
ITEM=
EXP=newones.dll
NAME=NavExcel
URL=http://www.doxdesk.com/parasite/NavExcel.html
KEY=CLSID\{D80C4E21-C346-4E21-8E64-20746AA20AEB}\InprocServer32
ITEM=
EXP=NavExcelBar.dll
NAME=Comodo Trust Toolbar
URL=http://www.trusttoolbar.com/
KEY=CLSID\{D80E1356-AC78-4218-961C-A7689B4CB7FE}\InprocServer32
ITEM=
EXP=Ttbbho.dll
NAME=Adware.DealHelper
URL=http://sarc.com/avcenter/venc/data/pf/adware.dealhelper.html
KEY=CLSID\{D848A3CA-0BFB-4DE0-BA9E-A57F0CCA1C13}\InprocServer32
ITEM=
EXP=Dealhlpr.dll
NAME=TROJ_DELF.CR trojan
URL=http://uk.trendmicro-europe.com/enterprise/security_info/ve_detail.php?VName=TROJ_DELF.CR
KEY=CLSID\{D8569837-3CD6-4AD7-9A77-65975B581925}\InprocServer32
ITEM=
EXP=dll
NAME=Unidentified hijacker
URL=
KEY=CLSID\{D879A0F1-2B3B-4409-8879-FAD6E49E1EA9}\InprocServer32
ITEM=
EXP=mshtmpre.dll
NAME=MediaUpdate/SafeSurfing
URL=http://www.doxdesk.com/parasite/MediaUpdate.html
KEY=CLSID\{D8E25C53-9508-4f5c-9249-D98D438891D5}\InprocServer32
ITEM=
EXP=ssurf022.dll
NAME=Adware.IEPageHelper
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453083026
KEY=CLSID\{D8E25C53-9508-4f5c-9249-D98D438891D5}\InprocServer32
ITEM=
EXP=inetdctr.dll
NAME=Csearch
URL=http://www.symantec.com/security_response/writeup.jsp?docid=2005-041417-1708-99
KEY=CLSID\{D8FA0364-7866-40A7-B340-A6069265AD9F}\InprocServer32
ITEM=
EXP=Csearch.dll
NAME=Unidentified malware
URL=
KEY=CLSID\{D8FF9A84-FEB9-4B4B-B36B-D46570203C39}\InprocServer32
ITEM=
EXP=key.dll
NAME=FastFind.org SubSearch
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453074896
KEY=CLSID\{D97287B6-4018-4060-948D-54D2122FC5C3}\InprocServer32
ITEM=
EXP=0002C00.dll
NAME=SecondPower Multimedia Speedbar
URL=http://support.microsoft.com/default.aspx?kbid=320159
KEY=CLSID\{D985E70B-97F1-477E-AF6C-66E496DEDBD6}\InprocServer32
ITEM=
EXP=2ndpower.dll
NAME=Subsearch
URL=http://www.doxdesk.com/parasite/SubSearch.html
KEY=CLSID\{D9A5A49C-60EB-4C07-8570-8FB8FE825E7C}\InprocServer32
ITEM=
EXP=sbsrch_v2.dll
NAME=EZSearching
URL=http://www.doxdesk.com/parasite/ezSearching.html
KEY=CLSID\{DB0018A2-F7D9-4B71-9651-640143DF23F9}\InprocServer32
ITEM=
EXP=ctap
NAME=Keylogger, probably LoveTester related
URL=http://spamwatch.codefish.net.au/modules.php?op=modload&name=News&file=index&catid=&topic=24
KEY=CLSID\{DCE80CA4-B555-44D8-B423-A75D6C345EE1}\InprocServer32
ITEM=
EXP=stype10.dll
NAME=MacigControl
URL=http://www.doxdesk.com/parasite/MagicControl.html
KEY=CLSID\{DE614603-6320-4046-A7A7-6A69CEC26F14}\InprocServer32
ITEM=
EXP=4b_1,0,0,5_navpmc.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{DF57FEB6-9BCE-45E3-AA65-BE327B8CCE7F}\InprocServer32
ITEM=
EXP=dat
NAME=Divago Surfairy
URL=http://www.doxdesk.com/parasite/Surfairy.html
KEY=CLSID\{E0B9B5FE-B66E-4FB0-A1D9-726F0E743CFD}\InprocServer32
ITEM=
EXP=SurfairyPP.dll
NAME=AdRoar
URL=http://doxdesk.com/parasite/AdRoar.html
KEY=CLSID\{E0F0E0E1-5D45-11D4-BC00-2DCC73302D70}\InprocServer32
ITEM=
EXP=cpr.dll
NAME=Unidentified adware
URL=
KEY=CLSID\{E155EDD6-FA1E-4876-8FB2-5FB358014EBE}\InprocServer32
ITEM=
EXP=sequitur1b.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{E2DDF680-9905-4dee-8C64-0A5DE7FE133C}\InprocServer32
ITEM=
EXP=mssearch.dll
NAME=Trojan.Win32.Delf.cf
URL=
KEY=CLSID\{E412F14A-E998-4543-9E7A-1031A3189A87}\InprocServer32
ITEM=
EXP=dll
NAME=i-Lookup/GlobalWebSearch
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{E539DEA3-BA67-4F1F-A897-5F2F4F29A063}\InprocServer32
ITEM=
EXP=winenc32.dll
NAME=CnsMin related
URL=http://www.doxdesk.com/parasite/CnsMin.html
KEY=CLSID\{E5E4E352-6947-44EE-A420-DB84EFD3FE93}\InprocServer32
ITEM=
EXP=ehelper.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{E7AFFF2A-1B57-49C7-BF6B-E5123394C970}\InprocServer32
ITEM=
EXP=webinfo.dll
NAME=Best Phrases adware
URL=http://www.spyany.com/program/article_adw_rm_Best_Phrases.html
KEY=CLSID\{E8B4F3AA-9509-4081-9A85-914D5E9BEC81}\InprocServer32
ITEM=
EXP=bpv1a.dll
NAME=MidAddle adware
URL=http://www.adrants.com/2004/06/adspyre-launches-midaddle-ad-system.php
KEY=CLSID\{E8EAEB34-F7B5-4C55-87FF-720FAF53D841}\InprocServer32
ITEM=
EXP=midaddle.dll
NAME=AdBlaster Adware
URL=http://www.spyany.com/program/article_adw_rm_AdBlaster.html
KEY=CLSID\{E9147A0A-A866-4214-B47C-DA821891240F}\InprocServer32
ITEM=
EXP=ngsw31.dll
NAME=NewtonKnows toolbar variant
URL=http://www.doxdesk.com/parasite/NewtonKnows.html
KEY=CLSID\{E9407738-A996-421A-A309-5C93C699E10A}\InprocServer32
ITEM=
EXP=ntoolbar.dll
NAME=SafeguardProtect/Veevo
URL=http://www.castlecops.com/tk1339-kdp_dll_random_char.html
KEY=CLSID\{E9C1FD9A-46B0-4185-84ED-E2F8ACD4A262}\InprocServer32
ITEM=
EXP=kdp
NAME=Gigasearch hijacker
URL=
KEY=CLSID\{EADD3112-0CF8-444b-AC0F-EBA38E004554}\InprocServer32
ITEM=
EXP=giga32.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{EB23F789-F17F-4bcc-988B-6B70A3A67E9C}\InprocServer32
ITEM=
EXP=Zero-Popup.dll
NAME=SpiderSearch, iLookup parasite variant
URL=http://www.doxdesk.com/parasite/ILookup.html
KEY=CLSID\{EB386233-65D7-46DC-A73D-0E02F2F844A9}\InprocServer32
ITEM=
EXP=winsps32.dll
NAME=FavoriteMan/SpyAssault
URL=http://www.doxdesk.com/parasite/FavoriteMan.html
KEY=CLSID\{EBBD88E5-C372-469D-B4C5-1FE00352AB9B}\InprocServer32
ITEM=
EXP=ss32.dll
NAME=Aureate/Radiate
URL=http://www.cexx.org/aureate.htm
KEY=CLSID\{EBBFE27C-BDF0-11D2-BBE5-00609419F467}\InprocServer32
ITEM=
EXP=amcis.dll
NAME=i-search.us hijacker
URL=
KEY=CLSID\{ECAD9C14-ED46-D58A-E847-ADBEFC8D37EB}\InprocServer32
ITEM=
EXP=IBHO2.DLL
NAME=SearchMiracle.EliteBar
URL=http://www.spynet.com/spyware/spyware-SearchMiracle.EliteBar.aspx
KEY=CLSID\{ED103D9F-3070-4580-AB1E-E5C179C1AE41}\InprocServer32
ITEM=
EXP=EliteSideBar
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{ED5ABC42-8E4F-4C39-9972-F0CF619D672F}\InprocServer32
ITEM=
EXP=dat
NAME=Icoo Loader
URL=http://www.by-users.co.uk/forums/?board=help&action=display&num=1085918311
KEY=CLSID\{ED657BAF-1EE5-4A07-9D2E-6D0525EFC69B}\InprocServer32
ITEM=
EXP=icoourlext.dll
NAME=UCmore toolbar
URL=http://www.doxdesk.com/parasite/UCmore.html
KEY=CLSID\{ED8DB0FD-D8F4-4b2c-BB5B-9EF040FE104D}\InprocServer32
ITEM=
EXP=Ucmie.dll
NAME=NewtonKnows search bar
URL=http://www.doxdesk.com/parasite/NewtonKnows.html
KEY=CLSID\{EE392A64-F30B-47C8-A363-CDA1CEC7DC1B}\InprocServer32
ITEM=
EXP=Bar.dll
NAME=RelatedLinks adware
URL=http://www.kephyr.com/spywarescanner/library/relatedlinks.lbbho/index.phtml
KEY=CLSID\{EFD84954-6B46-42f4-81F3-94CE9A77052D}\InprocServer32
ITEM=
EXP=lbbho.dll
NAME=Parasite, as yet unidentified
URL=
KEY=CLSID\{EFF80427-F837-4B74-8834-BAF18E0553FD}\InprocServer32
ITEM=
EXP=dll
NAME=Adware.Begin2Search
URL=http://sarc.com/avcenter/venc/data/adware.begin2search.html
KEY=CLSID\{F0C08B30-BA30-4FEB-924B-2E250CF0697D}\InprocServer32
ITEM=
EXP=siq.dll
NAME=ZyncosMark
URL=http://www.tek-tips.com/gviewthread.cfm/lev2/8/lev3/57/pid/538/qid/221627
KEY=CLSID\{F0DC0CFE-D11A-489B-84C0-63748AFAABF3}\InprocServer32
ITEM=
EXP=Cmctl.dll
NAME=Keywords
URL=http://doxdesk.com/parasite/Keywords.html parasite
KEY=CLSID\{F104576A-91BA-40AD-91DE-2C20801339AB}\InprocServer32
ITEM=
EXP=Keywords001.dll
NAME=Adware.Syslibie
URL=http://sarc.com/avcenter/venc/data/adware.syslibie.html
KEY=CLSID\{F195A1A9-4033-4E5B-B85C-848C3E31A83A}\InprocServer32
ITEM=
EXP=syslibie.dll
NAME=Alexa
URL=http://www.safersite.com/PestInfo/a/Alexa_Toolbar.asp
KEY=CLSID\{F1FABE79-25FC-46de-8C5A-2C6DB9D64333}\InprocServer32
ITEM=
EXP=AlxTB1.dll
NAME=SafeguardProtect/Veevo
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453082734
KEY=CLSID\{F281FFC7-6C63-4bf9-83F2-AB7A6157B109}\InprocServer32
ITEM=
EXP=kdpupd.dll
NAME=Roings.com adware
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453079089
KEY=CLSID\{F2863EDE-7980-443A-AEA2-0F46076D590F}\InprocServer32
ITEM=
EXP=Wat.dll
NAME=WurldMedia
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=59272
KEY=CLSID\{F325E940-45EE-11D7-A420-444553540000}\InprocServer32
ITEM=
EXP=M030206POHS.DLL
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{F32F8ECD-6CF3-459D-82F2-9738392C85A8}\InprocServer32
ITEM=
EXP=dat
NAME=GamSYS
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453073363
KEY=CLSID\{F36C1198-FC6B-4012-9928-DFA76FB56CC3}\InprocServer32
ITEM=
EXP=GAMhelper.dll
NAME=BestPhrases variant
URL=http://www3.ca.com/securityadvisor/pest/pest.aspx?id=453079088
KEY=CLSID\{F4A645D0-D4D5-439E-9DBC-B31BBD9CB890}\InprocServer32
ITEM=
EXP=BPV2s.dll
NAME=eXact Advertising
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453090718
KEY=CLSID\{F4E04583-354E-4076-BE7D-ED6A80FD66DA}\InprocServer32
ITEM=
EXP=msbe.dll
NAME=Netguarder Web Cleaner
URL=http://research.sunbelt-software.com/threatdisplay.aspx?threatid=8964
KEY=CLSID\{F585D290-1BF4-480A-AEC2-4182593F1E32}\InprocServer32
ITEM=
EXP=Webtool.dll
NAME=WurldMedia
URL=
KEY=CLSID\{F59D88CF-939A-4E50-9587-65A2E22EF077}\InprocServer32
ITEM=
EXP=mob030612.dll
NAME=Adware.Magicads
URL=http://sarc.com/avcenter/venc/data/adware.magicads.html
KEY=CLSID\{F760CB9E-C60F-4A89-890E-FAE8B849493E}\InprocServer32
ITEM=
EXP=Madise.dll
NAME=Dyfuca/Internet Optimizer
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453072536
KEY=CLSID\{F7F808F0-6F7D-442C-93E3-4A4827C2E4C8}\InprocServer32
ITEM=
EXP=opti130.dll
NAME=eXact Search Bar
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453072519
KEY=CLSID\{F9765480-72D1-11D4-A75A-004F49045A87}\InprocServer32
ITEM=
EXP=eXactToolbar.dll
NAME=Adware.Margoc variant
URL=http://sarc.com/avcenter/venc/data/adware.margoc.html
KEY=CLSID\{FA040B34-FBE9-4BEF-9D85-F90BECAACA99}\InprocServer32
ITEM=
EXP=dll
NAME=EliteBar/SearchMiracle adware
URL=http://www.giantcompany.com/antispyware/research/spyware/spyware-SearchMiracle.EliteBar.aspx
KEY=CLSID\{FA6548E9-78F5-4025-9D7B-FC1367789C38}\InprocServer32
ITEM=
EXP=Elitebar.dll
NAME=Meridian popupper
URL=http://www.castlecops.com/tk649-no_name.html
KEY=CLSID\{FA79FA22-8DB3-43D1-997B-6DBFD8845569}\InprocServer32
ITEM=
EXP=Myaccess.dll
NAME=AdRoar
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453077256
KEY=CLSID\{FAC6E0E1-5D45-4907-BC00-302D702DCC73}\InprocServer32
ITEM=
EXP=cpr.dll
NAME=i-lookup search bar
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453074914
KEY=CLSID\{FBAA0B9E-A059-43E4-9699-76EB0AEB975B}\InprocServer32
ITEM=
EXP=Gws.dll
NAME=BlazeFind Websearch
URL=http://www.spywareguide.com/product_show.php?id=724
KEY=CLSID\{FBED6A02-71FB-11D8-86B0-0002441A9695}\InprocServer32
ITEM=
EXP=5_0_1browserhelper5.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{FC2593E3-3E5A-410F-AF3D-82613CCE58E5}\InprocServer32
ITEM=
EXP=sr.dll
NAME=Hijacker,  as yet unidentified
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453073363
KEY=CLSID\{FC4C5EAE-66EE-11D4-BC67-0000E8E582D2}\InprocServer32
ITEM=
EXP=e2bho.dll
NAME=Xpehbam.biz dialer related malware
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453077027
KEY=CLSID\{FCADDC14-BD46-408A-9842-111111111111}\InprocServer32
ITEM=
EXP=Backup.dll
NAME=Xpehbam.biz dialer related malware
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453109638
KEY=CLSID\{FCADDC14-BD46-408A-9842-CDB57890086B}\InprocServer32
ITEM=
EXP=Dial.dll
NAME=ClientMan
URL=http://www.ca.com/us/securityadvisor/pest/pest.aspx?id=453074909
KEY=CLSID\{FCADDC14-BD46-408A-9842-CDBE1C6D37EB}\InprocServer32
ITEM=
EXP=browserhelpere
NAME=AdwareSpy
URL=http://www.netrn.net/archives2/000596.html
KEY=CLSID\{FCADDC14-BD46-408A-9842-CDBE1C6D37EB}\InprocServer32
ITEM=
EXP=Adwarespy.dll
NAME=Adware.MultiClicker
URL=
KEY=CLSID\{FD3A6AB4-5527-4B52-90AF-F90CD3270861}\InprocServer32
ITEM=
EXP=inetconnect.dll
NAME=VirtuMonde adware variant
URL=http://securityresponse.symantec.com/avcenter/venc/data/adware.virtumonde.html
KEY=CLSID\{FD8609EC-7D7C-4778-AB8F-0053245550EF}\InprocServer32
ITEM=
EXP=dat
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{FD9BC004-8331-4457-B830-4759FF704C22}\InprocServer32
ITEM=
EXP=Msiesh.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=CLSID\{FF1BF4C7-4E08-4A28-A43F-9D60A9F7A880}\InprocServer32
ITEM=
EXP=Mshelper.dll
NAME=StickyPops.com adware
URL=
KEY=CLSID\{FF4E2C50-BCF3-47cf-952A-A512F5B5D0E8}\InprocServer32
ITEM=
EXP=DNSProxy.dll
NAME=Trojan.Magise
URL=http://securityresponse.symantec.com/avcenter/venc/data/trojan.magise.html
KEY=CLSID\{FFF5092F-7172-4018-827B-FA5868FB0478}\InprocServer32
ITEM=
EXP=msearch.dll
NAME=CasinoRewards software
URL=
KEY=CLSID\{FF905E0C-CFE9-4A90-AFFF-C13AF5D908F0}\InprocServer32
ITEM=
EXP=CasinoRewardsExplorerToolbar.dll
NAME=VX2 Variant
URL=http://www.doxdesk.com/parasite/Transponder.html 
KEY=CLSID\{FFD2825E-0785-40C5-9A41-518F53A8261F}\InprocServer32
ITEM=
EXP=SiteHlpr.dll
NAME=MPGcom toolbar
URL=http://www.xblock.com/product_show.php?id=726
KEY=CLSID\{FFFFFFFF-FFFF-FFFF-FFFF-5F8507C5F4E9}\InprocServer32
ITEM=
EXP=iempg.dll
NAME=EasySearch/UmaxSearch
URL=http://sarc.com/avcenter/venc/data/adware.umaxsearch.html
KEY=CLSID\{FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF}\InprocServer32
ITEM=
EXP=bin376.dll");



for(i=0;name[i];i++)
{
 if (DEBUG) display("clsid ",i,": ",name[i],"\n");
  check_reg(name:name[i], url:url[i], key:key[i], item:items[i], exp:exp[i]);
}


fill_names("NAME=NetNucleus/Mirar webband
URL=http://www.kephyr.com/spywarescanner/library/mirartoolbar.winnb42/index.phtml
KEY=
ITEM=
EXP=WinNB42.dll
NAME=NetNucleus/Mirar webband
URL=http://www.kephyr.com/spywarescanner/library/mirartoolbar.winnb41/index.phtml
KEY=
ITEM=
EXP=WinNB41.dll
NAME=Trojan.Win32.StartPage.ky hijacker
URL=
KEY=
ITEM=
EXP=msie32.dll
NAME=RelatedLinks adware
URL=http://www.kephyr.com/spywarescanner/library/relatedlinks.lbbho/index.phtml
KEY=
ITEM=
EXP=lbbho.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=
ITEM=
EXP=madopew.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=
ITEM=
EXP=mfplay.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=
ITEM=
EXP=msdoh.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=
ITEM=
EXP=rpcnt4.dll
NAME=hijacker
URL=http://computercops.biz/startuplist-6098.html
KEY=
ITEM=
EXP=msadblock32.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=
ITEM=
EXP=localsplnet.dll
NAME=CoolWebSearch parasite variant
URL=http://www.richardthelionhearted.com/~merijn/cwschronicles.html#
KEY=
ITEM=
EXP=aclui.dll");



if (DEBUG) display("start main for detection from hardrive\n");
for(i=0;name[i];i++)
{
   if (DEBUG) display("file ",i,": ",name[i],"\n");
   
   file =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\" + exp[i], string:rootfile); 
   handle = CreateFile (file:file, desired_access:GENERIC_READ, file_attributes:FILE_ATTRIBUTE_NORMAL,
                        share_mode:FILE_SHARE_READ, create_disposition:OPEN_EXISTING);
   if( ! isnull(handle) )
   {
     report = string(
    "The dll '"+name[i]+"' is present on the remote host\n",
    "Solution : "+url[i]+"\n",
    "Risk factor : High"); 
    security_hole(port:port, data:report);
    CloseFile(handle:handle);
  }
}
if (DEBUG) display("end main for detection from hardrive\n");

NetUseDel();
