#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(26987);
 script_version ("$Revision: 1.2 $");
 name["english"] = "Solaris 10 (sparc) : 125407-01";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 125407-01
(Webservices, SunOS 5.9 5.10 5.9_x86 5.10_x86: patch).

Date this patch was last updated by Sun : Wed Sep 05 09:02:00 MDT 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-125407-01-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 125407-01"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125407-01", obsoleted_by:"", package:"SUNWjaxb2", version:"2.0.3,REV=2006.11.15.05.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125407-01", obsoleted_by:"", package:"SUNWjaxws", version:"2.0,REV=2006.11.15.05.22");
e +=  solaris_check_patch(release:"5.10", arch:"sparc", patch:"125407-01", obsoleted_by:"", package:"SUNWxwss", version:"2.0,REV=2006.09.28.03.41");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
