#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(19580);
 script_version ("$Revision: 1.16 $");
 name["english"] = "Solaris 10 (i386) : 118669-16";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 118669-16
(JavaSE 5.0_x86: update 15 patch (equivalent to JDK 5.0u15), 64bit).

Date this patch was last updated by Sun : Wed Feb 27 13:39:49 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-118669-16-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 118669-16"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118669-16", obsoleted_by:"", package:"SUNWj5dmx", version:"1.5.0,REV=2005.03.04.02.15");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118669-16", obsoleted_by:"", package:"SUNWj5dvx", version:"1.5.0,REV=2005.03.04.02.15");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118669-16", obsoleted_by:"", package:"SUNWj5rtx", version:"1.5.0,REV=2005.03.04.02.15");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
