#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22984);
 script_version ("$Revision: 1.7 $");
 name["english"] = "Solaris 10 (i386) : 118966-25";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 118966-25
(X11 6.8.0_x86: Xorg patch).

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-118966-25-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 118966-25"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118966-25", obsoleted_by:"125720-03", package:"SUNWxorg-cfg", version:"6.8.2.5.10.0110,REV=0.2005.06.29");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118966-25", obsoleted_by:"125720-03", package:"SUNWxorg-client-programs", version:"6.8.2.5.10.0110,REV=0.2005.06.21");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118966-25", obsoleted_by:"125720-03", package:"SUNWxorg-doc", version:"6.8.0.5.10.7400,REV=0.2004.12.15");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118966-25", obsoleted_by:"125720-03", package:"SUNWxorg-graphics-ddx", version:"6.8.0.5.10.7400,REV=0.2004.12.15");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118966-25", obsoleted_by:"125720-03", package:"SUNWxorg-server", version:"6.8.0.5.10.7400,REV=0.2004.12.15");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"118966-25", obsoleted_by:"125720-03", package:"SUNWxorg-xkb", version:"6.8.0.5.10.7400,REV=0.2004.12.15");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
