#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22302);
 script_version ("$Revision: 1.24 $");
 name["english"] = "Solaris 10 (i386) : 119255-52";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 119255-52
(SunOS 5.10_x86: Install and Patch Utilities Patch).

Date this patch was last updated by Sun : Fri Feb 29 13:41:18 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-119255-52-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 119255-52"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119255-52", obsoleted_by:"", package:"SUNWinstall-patch-utils-root", version:"11.10,REV=2005.01.09.21.19");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119255-52", obsoleted_by:"", package:"SUNWpkgcmdsu", version:"11.11,REV=2005.01.09.21.19");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"119255-52", obsoleted_by:"", package:"SUNWswmt", version:"11.10,REV=2005.01.10.15.35");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
