#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27000);
 script_version ("$Revision: 1.3 $");
 name["english"] = "Solaris 10 (i386) : 125438-13";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 125438-13
(Web Server 7.0 Update 2 SunOS5.9_x86 5.10_x86: Update Release patch).

Date this patch was last updated by Sun : Thu Jan 31 09:51:13 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-125438-13-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 125438-13"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"125438-13", obsoleted_by:"", package:"SUNWwbsvr7", version:"7.0,REV=2006.12.04.08.22");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"125438-13", obsoleted_by:"", package:"SUNWwbsvr7-cli", version:"7.0,REV=2006.12.04.08.22");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"125438-13", obsoleted_by:"", package:"SUNWwbsvr7-dev", version:"7.0,REV=2006.12.04.08.22");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"125438-13", obsoleted_by:"", package:"SUNWwbsvr7x", version:"7.0,REV=2006.12.04.09.01");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
