#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30175);
 script_version ("$Revision: 1.1 $");
 name["english"] = "Solaris 10 (i386) : 136999-02";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 136999-02
(SunOS 5.10_x86: PostgreSQL 8.2 core patch).

Date this patch was last updated by Sun : Thu Jan 24 08:33:04 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-136999-02-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 136999-02"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"136999-02", obsoleted_by:"", package:"SUNWpostgr-82-client", version:"11.10.0,REV=2007.04.27.11.07");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"136999-02", obsoleted_by:"", package:"SUNWpostgr-82-contrib", version:"11.10.0,REV=2007.04.27.11.07");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"136999-02", obsoleted_by:"", package:"SUNWpostgr-82-devel", version:"11.10.0,REV=2007.04.27.11.07");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"136999-02", obsoleted_by:"", package:"SUNWpostgr-82-libs", version:"11.10.0,REV=2007.04.27.11.07");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"136999-02", obsoleted_by:"", package:"SUNWpostgr-82-pl", version:"11.10.0,REV=2007.04.27.11.07");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"136999-02", obsoleted_by:"", package:"SUNWpostgr-82-server", version:"11.10.0,REV=2007.04.27.11.07");
e +=  solaris_check_patch(release:"5.10_x86", arch:"i386", patch:"136999-02", obsoleted_by:"", package:"SUNWpostgr-82-server-data-root", version:"11.10.0,REV=2007.04.27.11.07");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
