#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12650);
 script_version ("$Revision: 1.9 $");
 script_bugtraq_id(4624);
 name["english"] = "Solaris 2.5.1 (sparc) : 103558-16";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 103558-16
(SunOS 5.5.1: admintool/launcher fixes + swmtool fixes & y2000).

Date this patch was last updated by Sun : Thu Jan 04 14:55:05 MST 2001

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-103558-16-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 103558-16"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.5.1", arch:"sparc", patch:"103558-16", obsoleted_by:"", package:"SUNWadmap", version:"6.5,REV=96.04.25.18.08");
e +=  solaris_check_patch(release:"5.5.1", arch:"sparc", patch:"103558-16", obsoleted_by:"", package:"SUNWadmc", version:"6.5,REV=96.04.25.17.31");
e +=  solaris_check_patch(release:"5.5.1", arch:"sparc", patch:"103558-16", obsoleted_by:"", package:"SUNWsadml", version:"6.5,REV=96.04.25.17.31");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-4624", value:TRUE);
}
