#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23113);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(6484);
 name["english"] = "Solaris 2.6 (sparc) : 106483-02";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 106483-02
(SunVTS 2.1.2: msg prob under locale 'ja' security startup disktest hang).

Date this patch was last updated by Sun : Tue Nov 17 16:44:25 MST 1998

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-106483-02-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 106483-02"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106483-02", obsoleted_by:"", package:"SUNWodu", version:"2.1.2,REV=13.98.01.27");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106483-02", obsoleted_by:"", package:"SUNWvts", version:"2.1.2,REV=13.98.01.27");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-6484", value:TRUE);
}
