#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23123);
 script_version ("$Revision: 1.5 $");
 name["english"] = "Solaris 2.6 (sparc) : 106881-03";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 106881-03
(SunScreen EFS 2.0: NAT, MP, and FW-1 conversion fixes).

Date this patch was last updated by Sun : Fri May 11 11:46:03 MDT 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-106881-03-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 106881-03"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106881-03", obsoleted_by:"", package:"SUNWfwcnv", version:"2.0,PATCH=3");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"106881-03", obsoleted_by:"", package:"SUNWicgSS", version:"2.0,PATCH=3");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
