#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23156);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(4911, 7457);
 name["english"] = "Solaris 2.6 (sparc) : 111891-10";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 111891-10
(Sun Ray Server version 1.3 Patch Update).

Date this patch was last updated by Sun : Fri Aug 01 09:50:39 MDT 2003

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-111891-10-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 111891-10"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"111891-10", obsoleted_by:"", package:"SUNWbbchr", version:"1.0_14.a,REV=2001.07.16.20.33");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"111891-10", obsoleted_by:"", package:"SUNWuta", version:"1.3_12.c,REV=2001.07.16.20.52");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"111891-10", obsoleted_by:"", package:"SUNWutesa", version:"1.3_12.c,REV=2001.07.16.20.52");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"111891-10", obsoleted_by:"", package:"SUNWuto", version:"1.3_12.c,REV=2001.07.16.20.52");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"111891-10", obsoleted_by:"", package:"SUNWutps", version:"1.3_12.c,REV=2001.07.16.20.52");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"111891-10", obsoleted_by:"", package:"SUNWutr", version:"1.3_12.c,REV=2001.07.16.20.52");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"111891-10", obsoleted_by:"", package:"SUNWutscr", version:"1.3_12.c,REV=2001.07.16.20.52");
e +=  solaris_check_patch(release:"5.6", arch:"sparc", patch:"111891-10", obsoleted_by:"", package:"SUNWutu", version:"1.3_12.c,REV=2001.07.16.20.52");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-4911", value:TRUE);
	set_kb_item(name:"BID-7457", value:TRUE);
}
