#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23172);
 script_version ("$Revision: 1.5 $");
 name["english"] = "Solaris 2.6 (i386) : 104830-02";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 104830-02
(FLEXlm 4.1c_x86: Patch for FLEXlm 4.1c and lit/lit_tty).

Date this patch was last updated by Sun : Fri Dec 24 13:22:26 MST 1999

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-104830-02-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 104830-02"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"104830-02", obsoleted_by:"", package:"SUNWlicsw", version:"4.2");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"104830-02", obsoleted_by:"", package:"SUNWlit", version:"4.0");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
