#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12976);
 script_version ("$Revision: 1.12 $");
 script_bugtraq_id(5161, 6309, 8314, 8831, 9962);
 name["english"] = "Solaris 2.6 (i386) : 105182-38";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 105182-38
(SunOS 5.6_x86: kernel update patch).

Date this patch was last updated by Sun : Thu Mar 04 10:20:18 MST 2004

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-105182-38-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 105182-38"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"105182-38", obsoleted_by:"", package:"SUNWarc", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"105182-38", obsoleted_by:"", package:"SUNWcsd", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"105182-38", obsoleted_by:"", package:"SUNWcsr", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"105182-38", obsoleted_by:"", package:"SUNWcsu", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"105182-38", obsoleted_by:"", package:"SUNWhea", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"105182-38", obsoleted_by:"", package:"SUNWnisu", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"105182-38", obsoleted_by:"", package:"SUNWsrh", version:"11.6.0,REV=1997.07.16.00.21");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-5161", value:TRUE);
	set_kb_item(name:"BID-6309", value:TRUE);
	set_kb_item(name:"BID-8314", value:TRUE);
	set_kb_item(name:"BID-8831", value:TRUE);
	set_kb_item(name:"BID-9962", value:TRUE);
}
