#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13041);
 script_version ("$Revision: 1.9 $");
 script_bugtraq_id(6665);
 name["english"] = "Solaris 2.6 (i386) : 107338-02";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 107338-02
(OpenWindows 3.6_x86: kcms_server and kcms_configure security fixes).

Date this patch was last updated by Sun : Wed Feb 04 14:18:28 MST 2004

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-107338-02-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 107338-02"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107338-02", obsoleted_by:"", package:"SUNWkcspg", version:"1.1,REV=1.14");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107338-02", obsoleted_by:"", package:"SUNWkcsrt", version:"1.1,REV=1.14");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-6665", value:TRUE);
}
