#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13044);
 script_version ("$Revision: 1.9 $");
 script_bugtraq_id(8305);
 name["english"] = "Solaris 2.6 (i386) : 107734-11";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 107734-11
(SunOS 5.6_x86: linker patch).

Date this patch was last updated by Sun : Mon Jul 28 10:00:15 MDT 2003

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-107734-11-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 107734-11"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107734-11", obsoleted_by:"", package:"SUNWarc", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107734-11", obsoleted_by:"", package:"SUNWbtool", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107734-11", obsoleted_by:"", package:"SUNWcsr", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107734-11", obsoleted_by:"", package:"SUNWcsu", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107734-11", obsoleted_by:"", package:"SUNWhea", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107734-11", obsoleted_by:"", package:"SUNWosdem", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107734-11", obsoleted_by:"", package:"SUNWtoo", version:"11.6.0,REV=1997.07.16.00.21");
e +=  solaris_check_patch(release:"5.6_x86", arch:"i386", patch:"107734-11", obsoleted_by:"", package:"SUNWxcu4", version:"11.6.0,REV=1997.07.16.00.21");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-8305", value:TRUE);
}
