#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13086);
 script_version ("$Revision: 1.22 $");
 script_bugtraq_id(10594, 5986, 7820, 8079, 8314, 8831, 8929, 9477, 9962);
 name["english"] = "Solaris 7 (sparc) : 106541-44";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 106541-44
(SunOS 5.7: Kernel Update Patch).

Date this patch was last updated by Sun : Wed Dec 06 14:59:08 MST 2006

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-106541-44-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 106541-44"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"FJSVhea", version:"1.0,REV=1998.11.16.20.05");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWarc", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWarcx", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWatfsr", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWcsl", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWcslx", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWcsr", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWcsu", version:"11.7.0,REV=1998.10.06.00.59");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWcsxu", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWdpl", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWdplx", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWesu", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWesxu", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWhea", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWipc", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWnisu", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWpcmci", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWpcmcu", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWpcmcx", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWscpu", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWscpux", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWssad", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWssadx", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWtnfc", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWtnfcx", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWtoo", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWtoox", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWvolr", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWvolu", version:"11.7.0,REV=1998.09.01.04.16");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"106541-44", obsoleted_by:"", package:"SUNWypu", version:"11.7.0,REV=1998.09.01.04.16");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-10594", value:TRUE);
	set_kb_item(name:"BID-5986", value:TRUE);
	set_kb_item(name:"BID-7820", value:TRUE);
	set_kb_item(name:"BID-8079", value:TRUE);
	set_kb_item(name:"BID-8314", value:TRUE);
	set_kb_item(name:"BID-8831", value:TRUE);
	set_kb_item(name:"BID-8929", value:TRUE);
	set_kb_item(name:"BID-9477", value:TRUE);
	set_kb_item(name:"BID-9962", value:TRUE);
}
