#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13102);
 script_version ("$Revision: 1.11 $");
 script_bugtraq_id(11050, 4630, 8973);
 name["english"] = "Solaris 7 (sparc) : 107178-03";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 107178-03
(CDE 1.3: libDtHelp.so.1 patch).

Date this patch was last updated by Sun : Tue Feb 03 10:21:49 MST 2004

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-107178-03-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 107178-03"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"107178-03", obsoleted_by:"", package:"SUNWdtbas", version:"1.3,REV=10.98.09.12");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"107178-03", obsoleted_by:"", package:"SUNWdtbax", version:"1.3,REV=10.98.09.11");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-11050", value:TRUE);
	set_kb_item(name:"BID-4630", value:TRUE);
	set_kb_item(name:"BID-8973", value:TRUE);
}
