#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13120);
 script_version ("$Revision: 1.9 $");
 script_bugtraq_id(4633);
 name["english"] = "Solaris 7 (sparc) : 107654-10";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 107654-10
(OpenWindows 3.6.1: X11R6.4 LBX & XRX Extensions Patch).

Date this patch was last updated by Sun : Thu May 09 12:53:46 MDT 2002

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-107654-10-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 107654-10"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"107654-10", obsoleted_by:"", package:"SUNWxwman", version:"3.7.2100,REV=0.98.08.05");
e +=  solaris_check_patch(release:"5.7", arch:"sparc", patch:"107654-10", obsoleted_by:"", package:"SUNWxwplt", version:"3.7.2103,REV=0.98.08.26");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-4633", value:TRUE);
}
