#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13312);
 script_version ("$Revision: 1.16 $");
 script_bugtraq_id(3763, 6061);
 name["english"] = "Solaris 8 (sparc) : 109134-33";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 109134-33
(SunOS 5.8: WBEM patch).

Date this patch was last updated by Sun : Thu Jul 06 10:51:01 MDT 2006

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-109134-33-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 109134-33"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWdclnt", version:"1.0,REV=2000.10.25.13.07");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWmga", version:"1.0,REV=2000.11.21.00.05");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWmgapp", version:"1.0,REV=1999.12.16.15.15");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWwbapi", version:"2.0,REV=1999.12.16.15.15");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWwbcor", version:"2.0,REV=1999.12.16.15.15");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWwbcou", version:"2.0,REV=1999.12.16.15.15");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWwbdev", version:"2.2,REV=2001.02.15.09.57");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWwbdoc", version:"2.2,REV=2001.01.23.23.08");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"109134-33", obsoleted_by:"", package:"SUNWwbmc", version:"11.8,REV=2000.11.21.00.05");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-3763", value:TRUE);
	set_kb_item(name:"BID-6061", value:TRUE);
}
