#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23326);
 script_version ("$Revision: 1.6 $");
 script_bugtraq_id(10088);
 name["english"] = "Solaris 8 (sparc) : 110648-40";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 110648-40
(Sun Cluster 3.0: Core/Sys Admin Patch).

Date this patch was last updated by Sun : Wed Nov 28 09:12:54 MST 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-110648-40-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 110648-40"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscdev", version:"3.0.0,REV=2000.10.01.01.00");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscgds", version:"3.0.0,REV=2001.09.14.00.00");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscr", version:"3.0.0,REV=2000.10.01.01.00");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscsal", version:"3.0.0,REV=2000.10.01.01.00");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscsam", version:"3.0.0,REV=2000.10.01.01.00");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscscn", version:"3.0.0,REV=2000.10.01.01.00");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscssv", version:"3.0.0,REV=2000.10.01.01.00");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscu", version:"3.0.0,REV=2000.10.01.01.00");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"110648-40", obsoleted_by:"", package:"SUNWscvm", version:"3.0.0,REV=2000.10.01.01.00");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-10088", value:TRUE);
}
