#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23365);
 script_version ("$Revision: 1.5 $");
 script_bugtraq_id(9899);
 name["english"] = "Solaris 8 (sparc) : 114796-04";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 114796-04
(Crypto Accelerator 4000 - 1.0: product patch).

Date this patch was last updated by Sun : Mon May 17 09:28:37 MDT 2004

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-114796-04-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 114796-04"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"114796-04", obsoleted_by:"", package:"SUNWkcl2a", version:"2.0.0,REV=2003.03.19.18.40");
e +=  solaris_check_patch(release:"5.8", arch:"sparc", patch:"114796-04", obsoleted_by:"", package:"SUNWkcl2o", version:"2.0.0,REV=2003.03.19.18.40");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-9899", value:TRUE);
}
