#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13422);
 script_version ("$Revision: 1.14 $");
 script_bugtraq_id(3763, 6061);
 name["english"] = "Solaris 8 (i386) : 109135-33";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 109135-33
(SunOS 5.8_x86: WBEM patch).

Date this patch was last updated by Sun : Thu Jul 06 10:46:37 MDT 2006

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-109135-33-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 109135-33"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWdclnt", version:"1.0,REV=2000.10.25.13.03");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWmga", version:"1.0,REV=2000.11.20.23.48");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWmgapp", version:"1.0,REV=1999.12.16.15.36");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWwbapi", version:"2.0,REV=1999.12.16.15.36");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWwbcor", version:"2.0,REV=1999.12.16.15.36");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWwbcou", version:"2.0,REV=1999.12.16.15.36.2");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWwbdev", version:"2.2,REV=2001.02.15.12.01");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWwbdoc", version:"2.2,REV=2001.01.24.00.11");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"109135-33", obsoleted_by:"", package:"SUNWwbmc", version:"11.8,REV=2000.11.20.23.48");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-3763", value:TRUE);
	set_kb_item(name:"BID-6061", value:TRUE);
}
