#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24218);
 script_version ("$Revision: 1.11 $");
 name["english"] = "Solaris 8 (i386) : 119135-12";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 119135-12
(Message Queue 3.6_x86 Service Pack 4 Patch 7 Solaris: C-API only).

Date this patch was last updated by Sun : Fri Oct 12 10:36:56 MDT 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-119135-12-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 119135-12"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"119135-12", obsoleted_by:"", package:"SUNWiqcdv", version:"3.6,REV=2004.11.18.14.39");
e +=  solaris_check_patch(release:"5.8_x86", arch:"i386", patch:"119135-12", obsoleted_by:"", package:"SUNWiqcrt", version:"3.6,REV=2004.11.18.14.39");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
