#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13552);
 script_version ("$Revision: 1.31 $");
 script_bugtraq_id(10594, 9852);
 name["english"] = "Solaris 9 (sparc) : 114332-25";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 114332-25
(c2audit & *libbsm.so.1 Patch).

Date this patch was last updated by Sun : Mon Apr 30 08:57:23 MDT 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-114332-25-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 114332-25"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWarc", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWcsl", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWcslx", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWcsr", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWcstl", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWcstlx", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWcsu", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWcsxu", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWhea", version:"11.9.0,REV=2002.04.06.15.27");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"114332-25", obsoleted_by:"122300-06 122300-07 122300-08 122300-09 122300-13 122300-14 122300-15 122300-17 122300-18 122300-19 122300-21", package:"SUNWvolr", version:"11.9.0,REV=2002.04.06.15.27");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-10594", value:TRUE);
	set_kb_item(name:"BID-9852", value:TRUE);
}
