#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13741);
 script_version ("$Revision: 1.18 $");
 name["english"] = "Solaris 9 (sparc) : 116340-07";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 116340-07
(SunOS 5.9: gzip and Freeware info files patch).

Date this patch was last updated by Sun : Wed Mar 07 11:44:36 MST 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-116340-07-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 116340-07"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"116340-07", obsoleted_by:"", package:"SUNWgzip", version:"11.9.0,REV=2002.03.02.00.35");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"116340-07", obsoleted_by:"", package:"SUNWgzipS", version:"11.9.0,REV=2002.03.02.00.35");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"116340-07", obsoleted_by:"", package:"SUNWsfinf", version:"11.9.0,REV=2002.03.02.00.35");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
