#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23694);
 script_version ("$Revision: 1.17 $");
 name["english"] = "Solaris 9 (sparc) : 120927-09";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 120927-09
(SunOS 5.9: Sun XVR-2500 Graphics Accelerator Patch).

Date this patch was last updated by Sun : Thu Oct 18 08:40:28 MDT 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-120927-09-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 120927-09"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"120927-09", obsoleted_by:"", package:"SUNWkfbcf", version:"9.0.0,REV=2006.08.08");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"120927-09", obsoleted_by:"", package:"SUNWkfbr", version:"9.0.0,REV=2006.08.08");
e +=  solaris_check_patch(release:"5.9", arch:"sparc", patch:"120927-09", obsoleted_by:"", package:"SUNWkfbw", version:"9.0.0,REV=2006.08.08");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
