#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13579);
 script_version ("$Revision: 1.10 $");
 name["english"] = "Solaris 9 (i386) : 112662-07";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 112662-07
(SunOS 5.9_x86: IIIM and X Input & Output Method patch).

Date this patch was last updated by Sun : Wed Nov 08 13:37:34 MST 2006

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-112662-07-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 112662-07"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"JSatsvw", version:"1.0,REV=2002.11.01.17.06");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWcleu", version:"9.0,REV=2002.08.19.13.15");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWhkleu", version:"9.0,REV=2002.08.19.13.15");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWhleu", version:"9.0,REV=2002.08.19.13.15");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWiiimr", version:"1.1,REV=1.0.59");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWiiimu", version:"1.1,REV=1.0.59");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWj3irt", version:"1.1,REV=1.0.55");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWjwncx", version:"1.2,REV=2002.03.07.13.19");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWjxplt", version:"1.5,REV=2002.03.04.19.40");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWlccom", version:"5.8,REV=2002.01.08.10.48");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWxi18n", version:"4.1,REV=1.0.59");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"112662-07", obsoleted_by:"", package:"SUNWxim", version:"4.1,REV=1.0.59");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
