#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13593);
 script_version ("$Revision: 1.17 $");
 script_bugtraq_id(8911);
 name["english"] = "Solaris 9 (i386) : 114145-08";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 114145-08
(SunOS 5.9_x86: Apache Security Patch).

Date this patch was last updated by Sun : Thu Jan 03 09:17:30 MST 2008

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-114145-08-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 114145-08"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"114145-08", obsoleted_by:"", package:"SUNWapchS", version:"11.9.0,REV=2002.08.06.16.05");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"114145-08", obsoleted_by:"", package:"SUNWapchd", version:"11.9.0,REV=2002.08.06.16.05");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"114145-08", obsoleted_by:"", package:"SUNWapchr", version:"11.9.0,REV=2002.08.06.16.05");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"114145-08", obsoleted_by:"", package:"SUNWapchu", version:"11.9.0,REV=2002.08.06.16.05");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
else 
{
	set_kb_item(name:"BID-8911", value:TRUE);
}
