#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(17135);
 script_version ("$Revision: 1.15 $");
 name["english"] = "Solaris 9 (i386) : 117725-10";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 117725-10
(NSPR 4.5.1 / NSS 3.9.5 / JSS 4.0).

Date this patch was last updated by Sun : Thu Sep 29 14:17:16 MDT 2005

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-117725-10-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 117725-10"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"117725-10", obsoleted_by:"119212-05 119212-11 119212-12 119212-14 119212-16", package:"SUNWjss", version:"3.1.2.3,REV=2003.03.08.13.04");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"117725-10", obsoleted_by:"119212-05 119212-11 119212-12 119212-14 119212-16", package:"SUNWpr", version:"4.1.3,REV=2003.01.09.13.59");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"117725-10", obsoleted_by:"119212-05 119212-11 119212-12 119212-14 119212-16", package:"SUNWprd", version:"4.1.6,REV=2003.09.08.11.26");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"117725-10", obsoleted_by:"119212-05 119212-11 119212-12 119212-14 119212-16", package:"SUNWtls", version:"3.3.3,REV=2003.01.09.17.07");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"117725-10", obsoleted_by:"119212-05 119212-11 119212-12 119212-14 119212-16", package:"SUNWtlsd", version:"3.3.6,REV=2003.09.08.11.32");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"117725-10", obsoleted_by:"119212-05 119212-11 119212-12 119212-14 119212-16", package:"SUNWtlsu", version:"3.3.7,REV=2003.12.01.12.23");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
