#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22252);
 script_version ("$Revision: 1.17 $");
 name["english"] = "Solaris 9 (i386) : 121317-02";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Sun Security Patch number 121317-02
(kernel/sys/doorfs Patch).

Date this patch was last updated by Sun : Fri Mar 02 08:42:40 MST 2007

You should install this patch for your system to be up-to-date.

Solution : http://sunsolve.sun.com/search/document.do?assetkey=1-21-121317-02-1
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for patch 121317-02"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Solaris Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Solaris/showrev");
 exit(0);
}



include("solaris.inc");

e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"121317-02", obsoleted_by:"122301-03 122301-04 122301-06 122301-07 122301-13 122301-14 122301-15 122301-17 122301-18 122301-19 122301-21", package:"SUNWcsr", version:"11.9.0,REV=2002.11.04.02.51");
e +=  solaris_check_patch(release:"5.9_x86", arch:"i386", patch:"121317-02", obsoleted_by:"122301-03 122301-04 122301-06 122301-07 122301-13 122301-14 122301-15 122301-17 122301-18 122301-19 122301-21", package:"SUNWhea", version:"11.9.0,REV=2002.11.04.02.51");
if ( e < 0 ) { 
	if ( NASL_LEVEL < 3000 ) 
	   security_hole(0);
	else  
	   security_hole(port:0, extra:solaris_get_report());
	exit(0); 
} 
